/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.configs.entities.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModTickers;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class ItemRarityTicker
extends Ticker<ItemEntity> {
    private static final TextColor WHITE_TEXT = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);
    private final List<TextColor> nameColors = new ArrayList<TextColor>();
    private final ItemStack stack = ((ItemEntity)this.entity).getItem();
    private final boolean isCommon = this.stack.getRarity() == Rarity.COMMON;

    public ItemRarityTicker(ItemEntity entity) {
        super(entity);
        this.getItemNameColors();
        if (this.isCommon && ModConfigs.ENTITIES.itemRarity.particlesDisplayType == ItemRarityConfigs.DisplayType.NOT_COMMON && this.nameColors.size() == 1 && this.nameColors.getFirst().equals((Object)WHITE_TEXT)) {
            this.nameColors.clear();
        }
    }

    private void getItemNameColors() {
        TextColor rarityColor;
        if (ModConfigs.ENTITIES.itemRarity.particleColor == ItemRarityConfigs.ColorType.NAME_COLOR) {
            boolean usesSingleColor;
            Component hoverName = this.stack.getHoverName();
            TextColor baseColor = hoverName.getStyle().getColor();
            ArrayList<TextColor> colors = new ArrayList<TextColor>(hoverName.getSiblings().stream().map(component -> component.getStyle().getColor()).filter(Objects::nonNull).toList());
            boolean bl = usesSingleColor = colors.isEmpty() || !ModConfigs.ENTITIES.itemRarity.mixedColorName;
            if (baseColor != null) {
                colors.add(baseColor);
            }
            if (usesSingleColor) {
                TextColor color;
                Object object = baseColor != null ? baseColor : (color = !colors.isEmpty() ? (TextColor)colors.getFirst() : null);
                if (color != null && (!this.isCommon || color.equals((Object)WHITE_TEXT))) {
                    this.nameColors.add(color);
                    return;
                }
            } else {
                this.nameColors.addAll(colors);
                return;
            }
        }
        if ((rarityColor = TextColor.fromLegacyFormat((ChatFormatting)this.stack.getRarity().color())) != null) {
            this.nameColors.add(rarityColor);
            return;
        }
        SubtleEffects.LOGGER.warn("Failed to get item display name color for item: {}", (Object)this.stack.getDisplayName());
        this.nameColors.add(WHITE_TEXT);
    }

    @Override
    public void tick() {
        if (this.nameColors.isEmpty()) {
            return;
        }
        if (ModTickers.shouldSpawn(this.random, ModConfigs.ENTITIES.itemRarity.particleDensity)) {
            this.level.addParticle((ParticleOptions)new IntegerParticleOptions(ModParticles.ITEM_RARITY.get(), (this.nameColors.size() > 1 ? this.nameColors.get(this.random.nextInt(this.nameColors.size())) : this.nameColors.getFirst()).getValue()), ((ItemEntity)this.entity).getRandomX(1.0), ((ItemEntity)this.entity).getY(), ((ItemEntity)this.entity).getRandomZ(1.0), 0.0, MathUtil.nextDouble(this.random, 0.02), 0.0);
        }
    }
}

