/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class DustCloudParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final double ySpeed;

    protected DustCloudParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int maxLifeTime, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, 0.0, zSpeed);
        this.sprites = sprites;
        this.ySpeed = ySpeed;
        this.gravity = 0.1f;
        this.lifetime = Math.max(this.random.nextInt(maxLifeTime), maxLifeTime - 10);
        this.speedUpWhenYMotionIsBlocked = true;
        this.alpha = ((Float)ModConfigs.ENTITIES.dustClouds.alpha.get()).floatValue();
        this.setSpriteFromAge(sprites);
        this.scale(3.0f * ((Float)ModConfigs.ENTITIES.dustClouds.scale.get()).floatValue());
        this.setSize(0.25f, 0.25f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        if (this.age >= this.lifetime / 3 * 2) {
            this.yd *= this.ySpeed / (double)(this.random.nextInt(3, 7) * 1000);
            this.alpha -= 0.1f;
        }
        if (this.onGround || this.alpha <= 0.0f) {
            this.remove();
        }
    }

    public record LargeProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DustCloudParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 35, this.sprites);
        }
    }

    public record SmallProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DustCloudParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 25, this.sprites);
        }
    }
}

