/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class ClientLivingEntityMixin<T extends Entity>
extends Entity {
    @Shadow
    public int hurtTime;
    @Shadow
    public int deathTime;

    public ClientLivingEntityMixin(EntityType<T> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tickDeath"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;deathTime:I", ordinal=0)})
    private void deathTick(CallbackInfo ci) {
        if (!this.level().isClientSide) {
            return;
        }
        if (ModConfigs.ENTITIES.wardenDeathSoulParticles && this.getType().equals(EntityType.WARDEN) && this.deathTime == 1 && !this.isRemoved()) {
            for (int i = 0; i < this.random.nextIntBetweenInclusive(3, 5); ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, this.position().x() + (double)(this.getBbWidth() / 2.0f) + MathUtil.nextNonAbsDouble(this.random), this.position().y() + (double)(this.getBbHeight() / 2.0f) + MathUtil.nextNonAbsDouble(this.random), this.position().z() + (double)(this.getBbWidth() / 2.0f) + MathUtil.nextNonAbsDouble(this.random), 0.0, (double)Mth.nextFloat((RandomSource)this.getRandom(), (float)0.01f, (float)0.1f), 0.0);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        EntityType type;
        if (this.level().isClientSide && !this.isInvulnerableTo(source) && amount > 0.0f && source.getEntity() instanceof LivingEntity && this.isAlive() && this.hurtTime == 0 && ModDamageListeners.REGISTERED.containsKey(type = this.getType())) {
            ModDamageListeners.REGISTERED.get(type).apply(this, this.level(), this.random);
        }
    }
}

