/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.FrustumGetter;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin
implements FrustumGetter {
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    private Frustum cullingFrustum;
    @Shadow
    @Final
    private Minecraft minecraft;

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;RAIN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private ResourceLocation replaceRainTexture(Operation<ResourceLocation> original) {
        if (ModConfigs.BIOMES.biomeColorRain) {
            return Util.COLORLESS_RAIN_TEXTURE;
        }
        return (ResourceLocation)original.call(new Object[0]);
    }

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;setColor(FFFF)Lcom/mojang/blaze3d/vertex/VertexConsumer;")})
    private VertexConsumer renderSnowAndRain(VertexConsumer instance, float red, float green, float blue, float alpha, Operation<VertexConsumer> original, @Local Biome biome, @Local Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN && ModConfigs.BIOMES.biomeColorRain) {
            int waterColor = biome.getWaterColor();
            return instance.setColor((float)(waterColor >> 16) / 255.0f, (float)(waterColor >> 8) / 255.0f, (float)waterColor / 255.0f, alpha);
        }
        return (VertexConsumer)original.call(new Object[]{instance, Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(alpha)});
    }

    @Inject(method={"levelEvent"}, at={@At(value="TAIL")})
    private void levelEvent(int type, BlockPos pos, int data, CallbackInfo ci) {
        if (this.level == null) {
            return;
        }
        RandomSource random = this.level.getRandom();
        BlockState state = this.level.getBlockState(pos);
        LocalPlayer player = this.minecraft.player;
        switch (type) {
            case 1029: {
                if (!ModConfigs.BLOCKS.anvilBreakParticles) break;
                this.level.addDestroyBlockEffect(pos, Blocks.ANVIL.defaultBlockState());
                break;
            }
            case 1030: {
                if (!ModConfigs.BLOCKS.anvilUseParticles) break;
                float pointX = random.nextFloat();
                float pointZ = random.nextFloat();
                for (int i = 0; i < 20; ++i) {
                    int xSign = MathUtil.nextSign(random);
                    int zSign = MathUtil.nextSign(random);
                    this.level.addParticle((ParticleOptions)SparkParticle.create(SparkType.METAL, random), (double)((float)pos.getX() + pointX), (double)(pos.getY() + 1), (double)((float)pos.getZ() + pointZ), (double)(Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * (float)xSign), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)(Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * (float)zSign));
                }
                break;
            }
            case 1042: {
                if (!ModConfigs.BLOCKS.grindstoneUseParticles) break;
                Direction direction = (Direction)state.getValue((Property)GrindstoneBlock.FACING);
                AttachFace face = (AttachFace)state.getValue((Property)GrindstoneBlock.FACE);
                Direction side = face == AttachFace.CEILING ? Direction.DOWN : Direction.UP;
                for (int i = 0; i < 20; ++i) {
                    ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)SparkParticle.create(SparkType.METAL, random), 0.0f, side, (Level)this.level, pos, random, (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepX() * 1.5), face == AttachFace.CEILING ? 0.0 : (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepZ() * 1.5));
                }
                break;
            }
            case 2013: {
                ParticleSpawnUtil.spawnEntityFellParticles((LivingEntity)player, pos.getY() + 1, 0.0f, 5, ModConfigs.ENTITIES.dustClouds.landMaceAttack);
            }
        }
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;LARGE_SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceSmoke(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.lavaFizzSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;CLOUD:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceCloud(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.spongeDryingOutSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @ModifyReturnValue(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="RETURN", ordinal=0)})
    private Particle spawnForcedParticle(Particle particle) {
        if (particle != null) {
            ((ParticleAccessor)particle).subtleEffects$force();
        }
        return particle;
    }

    @Override
    public Frustum subtleEffects$getCullingFrustum() {
        return this.cullingFrustum;
    }
}

