/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.data.SparkProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class SparkProviderReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "subtle_effects/spark_providers";
    public static final Gson GSON = new GsonBuilder().create();
    public static final Map<ResourceLocation, SparkProvider> SPARK_PROVIDERS = new HashMap<ResourceLocation, SparkProvider>();

    public SparkProviderReloadListener() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller filler) {
        SPARK_PROVIDERS.clear();
        resources.forEach((id, element) -> SparkProvider.CODEC.parse((DynamicOps)JsonOps.INSTANCE, element).resultOrPartial(error -> SubtleEffects.LOGGER.error("Failed to decode spark provider with ID {} - Error: {}", id, error)).ifPresent(provider -> provider.options().ifPresent(options -> SPARK_PROVIDERS.put((ResourceLocation)id, (SparkProvider)provider))));
    }
}

