/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModPackets;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModTickers;
import einstein.subtle_effects.tickers.TickerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModPackets.initClientHandlers();
        ModTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticles.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.player;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                TickerManager.clear();
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.isPaused()) {
            return;
        }
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        TickerManager.tickTickers(level);
        HAS_CLEARED = false;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then(LiteralArgumentBuilder.literal((String)"particles").then(LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$0(minecraft, (Player)player, arg_0))))).then(LiteralArgumentBuilder.literal((String)"tickers").then(LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$1((Player)player, arg_0)))));
    }

    private static void sendSystemMsg(Player player, Component component) {
        if (player != null) {
            player.sendSystemMessage(component);
        }
    }

    private static /* synthetic */ int lambda$registerClientCommands$1(Player player, CommandContext context) throws CommandSyntaxException {
        TickerManager.clear();
        SubtleEffectsClient.sendSystemMsg(player, (Component)Component.translatable((String)"commands.subtle_effects.subtle_effects.tickers.clear.success"));
        return 1;
    }

    private static /* synthetic */ int lambda$registerClientCommands$0(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        minecraft.particleEngine.clearParticles();
        SubtleEffectsClient.sendSystemMsg(player, (Component)Component.translatable((String)"commands.subtle_effects.subtle_effects.particles.clear.success"));
        return 1;
    }
}

