/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.entity.decoration;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.entity.decoration.ArmorStandDataProvider;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandPose;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandStyleOption;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandStyleOptions;
import fuzs.statuemenus.api.v1.world.inventory.data.PosePartMutator;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.core.Proxy;
import fuzs.strawstatues.init.ModRegistry;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StrawStatue
extends ArmorStand
implements ArmorStandDataProvider {
    public static final Rotations DEFAULT_ENTITY_ROTATIONS = new Rotations(180.0f, 0.0f, 180.0f);
    public static final float DEFAULT_ENTITY_SCALE = 3.0f;
    public static final float MIN_MODEL_SCALE = 1.0f;
    public static final float MAX_MODEL_SCALE = 8.0f;
    public static final String OWNER_KEY = "Owner";
    public static final String PROFILE_KEY = "profile";
    public static final String SLIM_ARMS_KEY = "SlimArms";
    public static final String CROUCHING_KEY = "Crouching";
    public static final String MODEL_PARTS_KEY = "ModelParts";
    public static final String ENTITY_SCALE_KEY = "EntityScale";
    public static final String ENTITY_ROTATIONS_KEY = "EntityRotations";
    public static final EntityDataAccessor<Optional<ResolvableProfile>> DATA_PROFILE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.RESOLVABLE_PROFILE_ENTITY_DATA_SERIALIZER.value()));
    public static final EntityDataAccessor<Boolean> DATA_SLIM_ARMS = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_CROUCHING = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Float> DATA_ENTITY_SCALE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Rotations> DATA_ENTITY_ROTATIONS = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    private final NavigableMap<Float, EntityDimensions> defaultDimensions;
    private final NavigableMap<Float, EntityDimensions> babyDimensions;
    public float entityScaleO = 3.0f;
    public Rotations entityRotationsO = DEFAULT_ENTITY_ROTATIONS;

    public StrawStatue(EntityType<? extends StrawStatue> entityType, Level level) {
        super(entityType, level);
        ArmorStandStyleOption.setArmorStandData((ArmorStand)this, (boolean)true, (int)4);
        ArmorStandStyleOption.setArmorStandData((ArmorStand)this, (boolean)true, (int)8);
        this.defaultDimensions = StrawStatue.buildStatueDimensions(entityType, false);
        this.babyDimensions = StrawStatue.buildStatueDimensions(entityType, true);
    }

    public StrawStatue(Level level, double x, double y, double z) {
        this((EntityType<? extends StrawStatue>)((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()), level);
        this.setPos(x, y, z);
    }

    private static NavigableMap<Float, EntityDimensions> buildStatueDimensions(EntityType<?> entityType, boolean forBaby) {
        float defaultScale = 3.0f * (forBaby ? 2.0f : 1.0f);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (float scale = 1.0f; scale <= 8.0f; scale += 0.5f) {
            builder.put((Object)Float.valueOf(scale - 0.25f), (Object)entityType.getDimensions().scale(scale / defaultScale));
        }
        return builder.build();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PROFILE, Optional.empty());
        builder.define(DATA_SLIM_ARMS, (Object)false);
        builder.define(DATA_CROUCHING, (Object)false);
        builder.define(DATA_PLAYER_MODE_CUSTOMISATION, (Object)StrawStatue.getAllModelParts());
        builder.define(DATA_ENTITY_SCALE, (Object)Float.valueOf(3.0f));
        builder.define(DATA_ENTITY_ROTATIONS, (Object)DEFAULT_ENTITY_ROTATIONS);
    }

    private static byte getAllModelParts() {
        byte value = 0;
        for (PlayerModelPart modelPart : PlayerModelPart.values()) {
            value = (byte)(value | modelPart.getMask());
        }
        return value;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(SLIM_ARMS_KEY, this.slimArms());
        tag.putBoolean(CROUCHING_KEY, this.isCrouching());
        tag.putByte(MODEL_PARTS_KEY, ((Byte)this.entityData.get(DATA_PLAYER_MODE_CUSTOMISATION)).byteValue());
        ((Optional)this.entityData.get(DATA_PROFILE)).ifPresent(resolvableProfile -> tag.put(PROFILE_KEY, (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, resolvableProfile).getOrThrow()));
        tag.putFloat(ENTITY_SCALE_KEY, this.getEntityScale());
        Rotations entityRotations = this.getEntityRotations();
        if (!DEFAULT_ENTITY_ROTATIONS.equals((Object)entityRotations)) {
            tag.put(ENTITY_ROTATIONS_KEY, (Tag)entityRotations.save());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains(SLIM_ARMS_KEY, 1)) {
            this.setSlimArms(tag.getBoolean(SLIM_ARMS_KEY));
        }
        if (tag.contains(CROUCHING_KEY, 1)) {
            this.setCrouching(tag.getBoolean(CROUCHING_KEY));
        }
        if (tag.contains(MODEL_PARTS_KEY, 1)) {
            this.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)tag.getByte(MODEL_PARTS_KEY));
        }
        Optional<Dynamic> optional = tag.contains(PROFILE_KEY, 10) ? Optional.of(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(PROFILE_KEY))) : (tag.contains(OWNER_KEY, 10) ? Optional.of(ItemStackComponentizationFix.fixProfile((Dynamic)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(OWNER_KEY)))) : Optional.empty());
        optional.map(arg_0 -> ((Codec)ResolvableProfile.CODEC).parse(arg_0)).flatMap(dataResult -> dataResult.resultOrPartial(string -> StrawStatues.LOGGER.error("Failed to load profile from player head: {}", string))).ifPresent(this::setProfile);
        if (tag.contains(ENTITY_SCALE_KEY, 5)) {
            this.setEntityScale(tag.getFloat(ENTITY_SCALE_KEY));
            this.entityScaleO = this.getEntityScale();
        }
        if (tag.contains(ENTITY_ROTATIONS_KEY, 9)) {
            Rotations entityRotations = new Rotations(tag.getList(ENTITY_ROTATIONS_KEY, 5));
            this.setEntityRotations(entityRotations.getX(), entityRotations.getZ());
            this.entityRotationsO = this.getEntityRotations();
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isMarker() || this.babyDimensions == null || this.defaultDimensions == null) {
            return super.getDefaultDimensions(pose);
        }
        NavigableMap<Float, EntityDimensions> dimensions = this.isBaby() ? this.babyDimensions : this.defaultDimensions;
        return dimensions.floorEntry(Float.valueOf(this.getEntityScale())).getValue();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_ENTITY_SCALE.equals(key)) {
            this.refreshDimensions();
        } else if (DATA_PROFILE.equals(key)) {
            Proxy.INSTANCE.setModelPartsScreenGameProfile(this.getProfile());
        }
        super.onSyncedDataUpdated(key);
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand interactionHand) {
        ResolvableProfile resolvableProfile;
        ItemStack itemInHand;
        if (!(player.level().isClientSide || player.isSpectator() || this.isMarker() || !(itemInHand = player.getItemInHand(interactionHand)).is(Items.PLAYER_HEAD) || (resolvableProfile = (ResolvableProfile)itemInHand.get(DataComponents.PROFILE)) == null || Objects.equals(resolvableProfile.name(), this.getProfile().flatMap(ResolvableProfile::name)))) {
            this.setProfile(resolvableProfile);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, vec, interactionHand);
    }

    public static EventResultHolder<InteractionResult> onUseEntityAt(Player player, Level level, InteractionHand interactionHand, Entity target, Vec3 hitVector) {
        if (!player.isSpectator() && target.getType() == ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()) {
            return ArmorStandInteractHelper.tryOpenArmorStatueMenu((Player)player, (Level)level, (InteractionHand)interactionHand, (ArmorStand)((ArmorStand)target), (MenuType)((MenuType)ModRegistry.STRAW_STATUE_MENU_TYPE.value()), null);
        }
        return EventResultHolder.pass();
    }

    public boolean isShowArms() {
        return true;
    }

    public boolean isNoBasePlate() {
        return true;
    }

    public Optional<ResolvableProfile> getProfile() {
        return (Optional)this.entityData.get(DATA_PROFILE);
    }

    public void setProfile(@Nullable ResolvableProfile resolvableProfile) {
        this.entityData.set(DATA_PROFILE, Optional.ofNullable(resolvableProfile));
        if (resolvableProfile != null && !resolvableProfile.isResolved()) {
            resolvableProfile.resolve().thenAcceptAsync(newResolvableProfile -> this.entityData.set(DATA_PROFILE, Optional.of(newResolvableProfile)), SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }

    public boolean slimArms() {
        return (Boolean)this.entityData.get(DATA_SLIM_ARMS);
    }

    public void setSlimArms(boolean slimArms) {
        this.entityData.set(DATA_SLIM_ARMS, (Object)slimArms);
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        return ((Byte)this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION) & part.getMask()) == part.getMask();
    }

    public void setModelPart(PlayerModelPart modelPart, boolean enable) {
        this.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)ArmorStandStyleOption.setBit((byte)((Byte)this.entityData.get(DATA_PLAYER_MODE_CUSTOMISATION)), (int)modelPart.getMask(), (boolean)enable));
    }

    public float getEntityScale() {
        return ((Float)this.entityData.get(DATA_ENTITY_SCALE)).floatValue();
    }

    public float getEntityXRotation() {
        return this.getEntityRotations().getX();
    }

    public Rotations getEntityRotations() {
        return (Rotations)this.entityData.get(DATA_ENTITY_ROTATIONS);
    }

    public float getEntityZRotation() {
        return this.getEntityRotations().getZ();
    }

    public void setEntityXRotation(float rotationX) {
        this.setEntityRotations(rotationX, this.getEntityZRotation());
    }

    public void setEntityZRotation(float rotationZ) {
        this.setEntityRotations(this.getEntityXRotation(), rotationZ);
    }

    public void setEntityRotations(float rotationX, float rotationZ) {
        rotationX = Mth.clamp((float)rotationX, (float)0.0f, (float)360.0f);
        rotationZ = Mth.clamp((float)rotationZ, (float)0.0f, (float)360.0f);
        this.entityData.set(DATA_ENTITY_ROTATIONS, (Object)new Rotations(rotationX, 0.0f, rotationZ));
    }

    public void setEntityScale(float modelScale) {
        modelScale = StrawStatue.clampModelScale(modelScale);
        this.entityData.set(DATA_ENTITY_SCALE, (Object)Float.valueOf(modelScale));
    }

    public static float clampModelScale(double modelScale) {
        modelScale = (double)((int)(modelScale * 10.0)) / 10.0;
        return Mth.clamp((float)((float)modelScale), (float)1.0f, (float)8.0f);
    }

    public void baseTick() {
        super.baseTick();
        this.entityScaleO = this.getEntityScale();
        this.entityRotationsO = this.getEntityRotations();
    }

    public void setCrouching(boolean crouching) {
        this.entityData.set(DATA_CROUCHING, (Object)crouching);
    }

    public boolean isCrouching() {
        return (Boolean)this.entityData.get(DATA_CROUCHING);
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                    this.kill();
                    return false;
                }
                if (!(this.isInvulnerableTo(source) || this.isInvisible() || this.isMarker())) {
                    if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                        this.brokenByAnything(serverLevel, source);
                        this.kill();
                        return false;
                    }
                    if (source.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                        if (this.isOnFire()) {
                            this.causeDamage(serverLevel, source, 0.15f);
                        } else {
                            this.igniteForSeconds(5.0f);
                        }
                        return false;
                    }
                    if (source.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                        this.causeDamage(serverLevel, source, 4.0f);
                        return false;
                    }
                    boolean bl = source.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
                    boolean bl2 = source.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
                    if (!bl && !bl2) {
                        return false;
                    }
                    if (source.getEntity() instanceof Player && !((Player)source.getEntity()).getAbilities().mayBuild) {
                        return false;
                    }
                    if (source.isCreativePlayer()) {
                        this.playBrokenSound();
                        this.showBreakingParticles();
                        this.kill();
                        return true;
                    }
                    long gameTime = this.level().getGameTime();
                    if (gameTime - this.lastHit > 5L && !bl2) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)32);
                        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
                        this.lastHit = gameTime;
                        this.invulnerableTime = 20;
                        this.hurtTime = this.hurtDuration = 10;
                    } else {
                        this.brokenByPlayer(serverLevel, source);
                        this.showBreakingParticles();
                        this.kill();
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void brokenByPlayer(ServerLevel serverLevel, DamageSource damageSource) {
        ItemStack itemStack = new ItemStack((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value());
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemStack);
        this.brokenByAnything(serverLevel, damageSource);
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.HAY_BLOCK.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 32) {
            this.lastHit = this.level().getGameTime();
        }
        super.handleEntityEvent(id);
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.GRASS_FALL, SoundEvents.GRASS_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GRASS_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.GRASS_BREAK;
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value());
    }

    public ArmorStandScreenType[] getScreenTypes() {
        return new ArmorStandScreenType[]{ArmorStandScreenType.ROTATIONS, ArmorStandScreenType.POSES, ArmorStandScreenType.STYLE, ModRegistry.MODEL_PARTS_SCREEN_TYPE, ModRegistry.STRAW_STATUE_POSITION_SCREEN_TYPE, ModRegistry.STRAW_STATUE_SCALE_SCREEN_TYPE, ArmorStandScreenType.EQUIPMENT};
    }

    public PosePartMutator[] getPosePartMutators() {
        return new PosePartMutator[]{PosePartMutator.HEAD, ModRegistry.CAPE_POSE_PART_MUTATOR, PosePartMutator.RIGHT_ARM, PosePartMutator.LEFT_ARM, PosePartMutator.RIGHT_LEG, PosePartMutator.LEFT_LEG};
    }

    public ArmorStandPose getRandomPose(boolean clampRotations) {
        return ArmorStandPose.randomize((PosePartMutator[])this.getPosePartMutators(), (boolean)clampRotations);
    }

    public ArmorStandStyleOption[] getStyleOptions() {
        return new ArmorStandStyleOption[]{ArmorStandStyleOptions.SHOW_NAME, ArmorStandStyleOptions.SMALL, ModRegistry.SLIM_ARMS_STYLE_OPTION, ModRegistry.CROUCHING_STYLE_OPTION, ArmorStandStyleOptions.NO_GRAVITY, ArmorStandStyleOptions.SEALED};
    }
}

