/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.network.client;

import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandMenu;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class C2SStrawStatueScaleMessage
implements MessageV2<C2SStrawStatueScaleMessage> {
    private ScaleDataType type;
    private float value;

    public C2SStrawStatueScaleMessage() {
    }

    private C2SStrawStatueScaleMessage(ScaleDataType type, float value) {
        this.type = type;
        this.value = value;
    }

    public static Consumer<Float> getValueSender(ScaleDataType type) {
        return value -> StrawStatues.NETWORK.sendToServer(new C2SStrawStatueScaleMessage(type, value.floatValue()).toServerboundMessage());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.type);
        buf.writeFloat(this.value);
    }

    public void read(FriendlyByteBuf buf) {
        this.type = (ScaleDataType)buf.readEnum(ScaleDataType.class);
        this.value = buf.readFloat();
    }

    public MessageV2.MessageHandler<C2SStrawStatueScaleMessage> makeHandler() {
        return new MessageV2.MessageHandler<C2SStrawStatueScaleMessage>(this){

            public void handle(C2SStrawStatueScaleMessage message, Player player, Object gameInstance) {
                ArmorStandMenu menu;
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof ArmorStandMenu && (menu = (ArmorStandMenu)abstractContainerMenu).stillValid(player)) {
                    message.type.consumer.accept((StrawStatue)menu.getArmorStand(), Float.valueOf(message.value));
                }
            }
        };
    }

    public static enum ScaleDataType {
        SCALE(StrawStatue::setEntityScale),
        ROTATION_X(StrawStatue::setEntityXRotation),
        ROTATION_Z(StrawStatue::setEntityZRotation),
        RESET((strawStatue, value) -> {
            strawStatue.setEntityScale(3.0f);
            strawStatue.setEntityRotations(StrawStatue.DEFAULT_ENTITY_ROTATIONS.getX(), StrawStatue.DEFAULT_ENTITY_ROTATIONS.getZ());
        });

        public final BiConsumer<StrawStatue, Float> consumer;

        private ScaleDataType(BiConsumer<StrawStatue, Float> consumer) {
            this.consumer = consumer;
        }
    }
}

