/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.gui.screens;

import com.mojang.authlib.GameProfile;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import fuzs.statuemenus.api.v1.client.gui.components.TickBoxButton;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandTickBoxScreen;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.C2SStrawStatueModelPartMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueSetProfileMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Locale;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.component.ResolvableProfile;

public class StrawStatueModelPartsScreen
extends ArmorStandTickBoxScreen<PlayerModelPart> {
    public static final String TEXT_BOX_TRANSLATION_KEY = "strawstatues.screen.modelParts.name";
    public static final String REFRESH_SKIN_TRANSLATION_KEY = "strawstatues.screen.modelParts.refreshSkin";
    private static final ResourceLocation UNSEEN_NOTIFICATION_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/icon/unseen_notification.png");
    private AbstractWidget refreshProfileButton;

    public StrawStatueModelPartsScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    protected PlayerModelPart[] getAllTickBoxValues() {
        return PlayerModelPart.values();
    }

    protected AbstractWidget makeTickBoxWidget(ArmorStand armorStand, int buttonStartY, int index, PlayerModelPart option) {
        StrawStatue strawStatue = (StrawStatue)armorStand;
        return new TickBoxButton(this.leftPos + 96, this.topPos + buttonStartY + index * 22, 6, 76, option.getName(), () -> strawStatue.isModelPartShown(option), button -> {
            boolean value = !strawStatue.isModelPartShown(option);
            strawStatue.setModelPart(option, value);
            StrawStatues.NETWORK.sendToServer(new C2SStrawStatueModelPartMessage(option, value).toServerboundMessage());
        });
    }

    protected void syncNameChange(String input) {
        StrawStatues.NETWORK.sendToServer(new C2SStrawStatueSetProfileMessage(input, false).toServerboundMessage());
    }

    protected void init() {
        super.init();
        this.refreshProfileButton = (AbstractWidget)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 3, this.topPos + 31, 10, 10, 0, 0, 10, UNSEEN_NOTIFICATION_SPRITE, 10, 10, button -> {
            StrawStatues.NETWORK.sendToServer(new C2SStrawStatueSetProfileMessage(this.name.getValue().trim(), true).toServerboundMessage());
            button.visible = false;
        }).setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT));
        TooltipBuilder.create().addLines(new FormattedText[]{Component.translatable((String)REFRESH_SKIN_TRANSLATION_KEY)}).splitLines().build(this.refreshProfileButton);
        this.refreshProfileButton.visible = false;
        ((StrawStatue)this.getHolder().getArmorStand()).getProfile().map(ResolvableProfile::gameProfile).ifPresent(this::setGameProfile);
    }

    public void setGameProfile(GameProfile gameProfile) {
        if (this.refreshProfileButton != null) {
            this.refreshProfileButton.visible = C2SStrawStatueSetProfileMessage.isOfflinePlayerProfile(gameProfile);
        }
        if (this.name.getValue().toLowerCase(Locale.ROOT).equals(gameProfile.getName().toLowerCase(Locale.ROOT))) {
            this.name.setValue(gameProfile.getName());
        }
    }

    protected int getNameMaxLength() {
        return 16;
    }

    protected String getNameDefaultValue() {
        return ((StrawStatue)this.getHolder().getArmorStand()).getProfile().map(ResolvableProfile::gameProfile).map(GameProfile::getName).orElse("");
    }

    protected Component getNameComponent() {
        return Component.translatable((String)TEXT_BOX_TRANSLATION_KEY);
    }

    public ArmorStandScreenType getScreenType() {
        return ModRegistry.MODEL_PARTS_SCREEN_TYPE;
    }
}

