/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;

public class StorageUtil {
    public static void rebalanceDrawers(IDrawerGroup group, int slot) {
        IDrawer drawer = group.getDrawer(slot);
        if (drawer.isEnabled()) {
            StorageUtil.rebalanceDrawers(group, drawer.getStoredItemPrototype());
        }
    }

    public static void rebalanceDrawers(IDrawerGroup group, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        ArrayList<IDrawer> drawers = new ArrayList<IDrawer>();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled() || !ItemStackMatcher.areItemsEqual(drawer.getStoredItemPrototype(), stack)) continue;
            drawers.add(drawer);
        }
        StorageUtil.rebalanceDrawers(drawers.stream());
    }

    public static void rebalanceDrawers(Stream<IDrawer> drawers, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        StorageUtil.rebalanceDrawers(drawers.filter(d -> ItemStackMatcher.areItemsEqual(d.getStoredItemPrototype(), stack)));
    }

    public static void rebalanceDrawers(Stream<IDrawer> drawers) {
        if (!((Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableBalanceUpgrade.get()).booleanValue()) {
            return;
        }
        ArrayList<IDrawer> balanceDrawers = new ArrayList<IDrawer>();
        int aggCount = 0;
        for (IDrawer drawer : drawers.toList()) {
            if (!drawer.isEnabled()) continue;
            balanceDrawers.add(drawer);
            aggCount += drawer.getStoredItemCount();
        }
        if (balanceDrawers.size() > 1) {
            int dist = aggCount / balanceDrawers.size();
            int remainder = aggCount - dist * balanceDrawers.size();
            for (int i = 0; i < balanceDrawers.size(); ++i) {
                ((IDrawer)balanceDrawers.get(i)).setStoredItemCount(dist + (i < remainder ? 1 : 0));
            }
        }
    }
}

