/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked,
IFramedSourceBlock {
    public static final MapCodec<BlockCompDrawers> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("storageUnits").forGetter(BlockDrawers::getStorageUnits), (App)BlockCompDrawers.propertiesCodec()).apply((Applicative)instance, BlockCompDrawers::new));
    public static final EnumProperty<EnumCompDrawer> SLOTS = EnumProperty.create((String)"slots", EnumCompDrawer.class);

    public BlockCompDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockCompDrawers(int drawerCount, boolean halfDepth, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, BlockCompDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 16 : 32;
    }

    public BlockCompDrawers(int storageUnits, BlockBehaviour.Properties properties) {
        super(3, false, storageUnits, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SLOTS, (Comparable)((Object)EnumCompDrawer.OPEN1)));
    }

    public BlockCompDrawers(BlockBehaviour.Properties properties) {
        this(3, false, properties);
    }

    public MapCodec<BlockCompDrawers> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SLOTS});
    }

    @Override
    protected int getFaceSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        if (!this.hitWithinArea(correctSide, normalizedHit, 0.0625f, 0.9375f)) {
            return super.getFaceSlot(correctSide, normalizedHit);
        }
        if (this.hitWithinY(normalizedHit, 0.5f, 1.0f)) {
            return 0;
        }
        if (this.getDrawerCount() == 2) {
            return 1;
        }
        if (this.getDrawerCount() == 3) {
            if (this.hitWithinX(correctSide, normalizedHit, 0.0f, 0.5f)) {
                return 1;
            }
            return 2;
        }
        return super.getFaceSlot(correctSide, normalizedHit);
    }

    @Override
    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        BlockEntityDrawersComp blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawersComp.class);
        if (blockEntity != null) {
            IDrawerGroup group = blockEntity.getGroup();
            for (int i = group.getDrawerCount() - 1; i >= 0; --i) {
                if (group.getDrawer(i).isEmpty()) continue;
                world.setBlock(pos, (BlockState)state.setValue(SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(i + 1))), 3);
                break;
            }
        }
    }

    public BlockEntityDrawers newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntityDrawers)ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(this.getDrawerCount()).create(pos, state);
    }

    @Override
    public ItemStack makeFramedItem(ItemStack source, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        IFramedBlock frameBlock;
        switch (this.getDrawerCount()) {
            case 2: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_2.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_DRAWERS_2.get();
                break;
            }
            case 3: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_3.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_DRAWERS_3.get();
                break;
            }
            default: {
                IFramedBlock iFramedBlock = frameBlock = null;
            }
        }
        if (frameBlock == null) {
            return ItemStack.EMPTY;
        }
        return FrameHelper.makeFramedItem(frameBlock, source, matSide, matTrim, matFront);
    }
}

