/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.util;

import de.sarocesch.sarosroadblocksmod.block.entity.RoadBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RoadTextureManager {
    private static RoadTextureManager instance;
    private final Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();

    private RoadTextureManager() {
        this.registerDefaultTextures();
    }

    public static RoadTextureManager getInstance() {
        if (instance == null) {
            instance = new RoadTextureManager();
        }
        return instance;
    }

    private void registerDefaultTextures() {
        this.registerTexture("default", "block/road_block_fine");
        this.registerTexture("straight", "block/road_block_linie");
        this.registerTexture("corner", "block/road_block_linie_ecke");
        this.registerTexture("cross", "block/road_block_kreuzung");
        this.registerTexture("two", "block/two");
        this.registerTexture("tt", "block/tt");
        this.registerTexture("tf", "block/tf");
        this.registerTexture("ts", "block/ts");
        this.registerTexture("tse", "block/tse");
        this.registerTexture("te", "block/te");
        this.registerTexture("nt", "block/nt");
        this.registerTexture("thirty", "block/thirty");
        this.registerTexture("ohae", "block/ohae");
        this.registerTexture("ohat", "block/ohat");
        this.registerTexture("tta", "block/tta");
        this.registerTexture("tts", "block/tts");
        this.registerTexture("ttd", "block/ttd");
        this.registerTexture("ttf", "block/ttf");
        this.registerTexture("ttg", "block/ttg");
        this.registerTexture("tth", "block/tth");
        this.registerTexture("ttj", "block/ttj");
        this.registerTexture("ttk", "block/ttk");
        this.registerTexture("corner_straight", "block/corner_straight");
    }

    public void registerTexture(String id, String texturePath) {
        this.textureMap.put(id, ResourceLocation.fromNamespaceAndPath((String)"saros_road_blocks_mod", (String)texturePath));
    }

    public ResourceLocation getTexture(String id) {
        return this.textureMap.getOrDefault(id, this.textureMap.get("default"));
    }

    public static void setTextureForBlockEntity(BlockEntity blockEntity, String textureId) {
        if (blockEntity instanceof RoadBlockEntity) {
            RoadBlockEntity roadBlockEntity = (RoadBlockEntity)blockEntity;
            roadBlockEntity.setTextureId(textureId);
            blockEntity.setChanged();
        }
    }

    public static String getTextureFromBlockEntity(BlockEntity blockEntity) {
        if (blockEntity instanceof RoadBlockEntity) {
            RoadBlockEntity roadBlockEntity = (RoadBlockEntity)blockEntity;
            return roadBlockEntity.getTextureId();
        }
        return "default";
    }

    public static void setTextureForBlock(Level level, BlockPos pos, String textureId) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RoadBlockEntity) {
            RoadBlockEntity roadBlockEntity = (RoadBlockEntity)blockEntity;
            roadBlockEntity.setTextureId(textureId);
            blockEntity.setChanged();
            BlockState state = level.getBlockState(pos);
            level.sendBlockUpdated(pos, state, state, 3);
            level.getChunkAt(pos).setUnsaved(true);
        }
    }

    public static String getTextureForBlock(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RoadBlockEntity) {
            return RoadTextureManager.getTextureFromBlockEntity(blockEntity);
        }
        return "default";
    }
}

