/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.network;

import de.sarocesch.sarosroadblocksmod.procedures.ItemBasicProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.ItemCrossProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.ItemEckeProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.ItemGradEckProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.ItemGradecProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.ItemRemoveProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.P108Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P110Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P23Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P24Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P26Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P27Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P28Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P29Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P2Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.P30Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.TT1Procedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTAProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTDProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTFProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTGProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTHProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTJProcedure;
import de.sarocesch.sarosroadblocksmod.procedures.TTKProcedure;
import de.sarocesch.sarosroadblocksmod.world.inventory.GUIMenu;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="saros_road_blocks_mod")
public class GUIButtonMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"saros_road_blocks_mod", (String)"gui_button_message");
    public static final CustomPacketPayload.Type<GUIButtonMessage> TYPE = new CustomPacketPayload.Type(ID);
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    public static final StreamCodec<FriendlyByteBuf, GUIButtonMessage> STREAM_CODEC = StreamCodec.of((buf, message) -> message.write((FriendlyByteBuf)buf), buf -> new GUIButtonMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));

    public GUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GUIButtonMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player entity = context.player();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
        });
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GUIMenu.guistate;
        if (!world.hasChunkAt(BlockPos.containing((double)x, (double)y, (double)z))) {
            return;
        }
        if (buttonID == 0) {
            ItemBasicProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ItemRemoveProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ItemGradecProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ItemEckeProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ItemGradEckProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ItemCrossProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            P23Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            P24Procedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            P26Procedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            P27Procedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            P28Procedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            P29Procedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            P30Procedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            P108Procedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            P110Procedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            P2Procedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            TTAProcedure.execute((Entity)entity);
        }
        if (buttonID == 17) {
            TT1Procedure.execute((Entity)entity);
        }
        if (buttonID == 18) {
            TTDProcedure.execute((Entity)entity);
        }
        if (buttonID == 19) {
            TTFProcedure.execute((Entity)entity);
        }
        if (buttonID == 20) {
            TTGProcedure.execute((Entity)entity);
        }
        if (buttonID == 21) {
            TTHProcedure.execute((Entity)entity);
        }
        if (buttonID == 22) {
            TTJProcedure.execute((Entity)entity);
        }
        if (buttonID == 23) {
            TTKProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(RegisterPayloadHandlersEvent event) {
        event.registrar("saros_road_blocks_mod").playToServer(TYPE, STREAM_CODEC, GUIButtonMessage::handle);
    }
}

