/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.item;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import de.sarocesch.sarosroadblocksmod.world.inventory.GUIMenu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.loading.FMLPaths;

public class BrushItem
extends Item {
    public BrushItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)I18n.get((String)"tooltip.sarosroadblocksmod.brushitem.key", (Object[])new Object[0])));
    }

    private boolean isPainted(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            CompoundTag tag = customData.copyTag();
            return tag.contains("Painted") && tag.getBoolean("Painted");
        }
        return false;
    }

    private void togglePainted(ItemStack stack) {
        boolean painted = !this.isPainted(stack);
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = customData != null ? customData.copyTag() : new CompoundTag();
        tag.putBoolean("Painted", painted);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        if (painted) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        } else {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (player != null && player.isShiftKeyDown()) {
            if (!world.isClientSide()) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new GUIMenu(windowId, playerInventory, null), (Component)Component.translatable((String)"gui.saros_road_blocks_mod.gui")));
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState blockState = world.getBlockState(pos);
        if (blockState.getBlock() instanceof AsphaltBlock) {
            CompoundTag tag;
            AsphaltBlock asphaltBlock = (AsphaltBlock)blockState.getBlock();
            String modi = "";
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (customData != null && (tag = customData.copyTag()).contains("modi")) {
                modi = tag.getString("modi");
            }
            BlockState newState = blockState;
            boolean textureChanged = false;
            if ("rotate".equals(modi)) {
                newState = blockState.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
            } else if ("remove".equals(modi)) {
                newState = (BlockState)blockState.setValue(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)AsphaltBlock.TextureVariant.DEFAULT));
                RoadTextureManager.setTextureForBlock(world, pos, "default");
                textureChanged = true;
                if (!world.isClientSide()) {
                    world.sendBlockUpdated(pos, blockState, newState, 3);
                }
            } else {
                try {
                    AsphaltBlock.TextureVariant variant = AsphaltBlock.TextureVariant.valueOf(modi.toUpperCase());
                    newState = (BlockState)blockState.setValue(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)variant));
                    Direction playerFacing = player.getDirection();
                    newState = (BlockState)newState.setValue((Property)AsphaltBlock.FACING, (Comparable)playerFacing);
                    RoadTextureManager.setTextureForBlock(world, pos, modi.toLowerCase());
                    textureChanged = true;
                    if (!world.isClientSide()) {
                        world.sendBlockUpdated(pos, blockState, newState, 3);
                    }
                    if (newState != blockState || textureChanged) {
                        this.playPaintSound(world, pos);
                    }
                }
                catch (IllegalArgumentException e) {
                    return InteractionResult.PASS;
                }
            }
            if (newState != blockState || textureChanged) {
                BlockEntity blockEntity;
                world.setBlock(pos, newState, 3);
                if (!world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) != null) {
                    blockEntity.setChanged();
                    world.sendBlockUpdated(pos, newState, newState, 3);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void playPaintSound(Level world, BlockPos pos) {
        File configroads = new File(FMLPaths.GAMEDIR.get().toString() + "/config/", File.separator + "saro\u00b4s_road_blocks_mod.json");
        try {
            ResourceLocation soundLocation;
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configroads));
            StringBuilder jsonstringbuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                jsonstringbuilder.append(line);
            }
            bufferedReader.close();
            JsonObject main = (JsonObject)new Gson().fromJson(jsonstringbuilder.toString(), JsonObject.class);
            if (main.get("sounds").getAsBoolean() && BuiltInRegistries.SOUND_EVENT.containsKey(soundLocation = ResourceLocation.parse((String)"saros_road_blocks_mod:streichen"))) {
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundLocation);
                if (!world.isClientSide()) {
                    world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

