/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SidewalkBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);

    public SidewalkBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(3.0f, 20.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(VARIANT, (Comparable)((Object)Variant.DEFAULT));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int height = this.getHeightForVariant((Variant)((Object)state.getValue(VARIANT)));
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SidewalkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.EAST -> SidewalkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.SOUTH -> SidewalkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.WEST -> SidewalkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            default -> SidewalkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        };
    }

    private int getHeightForVariant(Variant variant) {
        return switch (variant.ordinal()) {
            case 1 -> 15;
            case 2 -> 14;
            case 3 -> 13;
            case 4 -> 12;
            case 5 -> 11;
            case 6 -> 10;
            case 7 -> 9;
            case 8 -> 8;
            case 9 -> 7;
            case 10 -> 6;
            case 11 -> 5;
            case 12 -> 4;
            case 13 -> 3;
            case 14 -> 2;
            case 15 -> 1;
            default -> 16;
        };
    }

    private Variant getNextVariant(Variant current) {
        Variant[] variants = Variant.values();
        int currentIndex = current.ordinal();
        return variants[(currentIndex + 1) % variants.length];
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT("default"),
        ONE("1"),
        TWO("2"),
        THREE("3"),
        FOUR("4"),
        FIVE("5"),
        SIX("6"),
        SEVEN("7"),
        EIGHT("8"),
        NINE("9"),
        TEN("10"),
        ELEVEN("11"),
        TWELVE("12"),
        THIRTEEN("13"),
        FOURTEEN("14"),
        FIFTEEN("15");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

