/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.mixin;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private int minHeight;
    @Shadow
    @Final
    private int minWidth;
    @Shadow
    @Final
    private ResourceLocation location;
    @Shadow
    @Final
    private int maxSupportedTextureSize;

    @Shadow
    protected abstract Map<ResourceLocation, TextureAtlasSprite> getStitchedSprites(Stitcher<SpriteContents> var1, int var2, int var3);

    @ModifyVariable(method={"stitch"}, at=@At(value="HEAD"), argsOnly=true)
    public List<SpriteContents> modifySpriteContents(List<SpriteContents> list) {
        ArrayList<SpriteContents> newList = new ArrayList<SpriteContents>(list);
        if (this.location.equals((Object)ResourceLocation.tryParse((String)"textures/atlas/particles.png"))) {
            int j;
            int j2;
            System.out.println("Registering weather particles");
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
            NativeImage rainImage = null;
            NativeImage snowImage = null;
            try {
                rainImage = ParticleRainClient.loadTexture(ResourceLocation.withDefaultNamespace((String)"textures/environment/rain.png"));
                snowImage = ParticleRainClient.loadTexture(ResourceLocation.withDefaultNamespace((String)"textures/environment/snow.png"));
                if (ParticleRainConfig.biomeTint) {
                    rainImage.applyToAllPixels(ParticleRainClient.desaturateOperation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (j2 = 0; j2 < 4; ++j2) {
                newList.add(ParticleRainClient.splitImage(rainImage, j2, "rain"));
            }
            for (j2 = 0; j2 < 4; ++j2) {
                newList.add(ParticleRainClient.splitImage(snowImage, j2, "snow"));
            }
            int rippleResolution = ParticleRainClient.getRippleResolution(newList);
            for (j = 0; j < 8; ++j) {
                newList.add(ParticleRainClient.generateRipple(j, rippleResolution));
            }
            if (ParticleRainConfig.biomeTint) {
                for (j = 0; j < 4; ++j) {
                    NativeImage splashImage = null;
                    try {
                        splashImage = ParticleRainClient.loadTexture(ResourceLocation.withDefaultNamespace((String)("textures/particle/splash_" + j + ".png")));
                        splashImage.applyToAllPixels(ParticleRainClient.desaturateOperation);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    newList.add(new SpriteContents(ResourceLocation.fromNamespaceAndPath((String)"particlerain", (String)("splash" + j)), new FrameSize(splashImage.getWidth(), splashImage.getHeight()), splashImage, ResourceMetadata.EMPTY));
                }
            }
        }
        return newList;
    }
}

