/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.ParticleRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public final class WeatherParticleSpawner {
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    private static void spawnParticle(ClientLevel level, Holder<Biome> biome, double x, double y, double z) {
        Biome.Precipitation precipitation;
        if (ParticleRainClient.particleCount > ParticleRainConfig.maxParticleAmount) {
            return;
        }
        if (!ParticleRainConfig.spawnAboveClouds && y > (double)ParticleRainConfig.cloudHeight) {
            y = ParticleRainConfig.cloudHeight;
        }
        if (ParticleRainConfig.doFogParticles && level.random.nextFloat() < (float)ParticleRainConfig.FogOptions.density / 100.0f) {
            level.addParticle((ParticleOptions)ParticleRegistry.FOG.get(), x, y, z, 0.0, 0.0, 0.0);
        }
        if ((precipitation = ((Biome)biome.value()).getPrecipitationAt(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos))) == Biome.Precipitation.RAIN) {
            int height;
            if (ParticleRainConfig.doGroundFogParticles && ParticleRainClient.fogCount < ParticleRainConfig.GroundFogOptions.density && (height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z)) <= ParticleRainConfig.GroundFogOptions.spawnHeight && height >= ParticleRainConfig.GroundFogOptions.spawnHeight - 4 && level.getFluidState(BlockPos.containing((double)x, (double)(height - 1), (double)z)).isEmpty()) {
                level.addParticle((ParticleOptions)ParticleRegistry.GROUND_FOG.get(), x, (double)((float)height + level.random.nextFloat()), z, 0.0, 0.0, 0.0);
            }
            if (ParticleRainConfig.doRainParticles && level.random.nextFloat() < (float)ParticleRainConfig.RainOptions.density / 100.0f) {
                level.addParticle((ParticleOptions)ParticleRegistry.RAIN.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (precipitation == Biome.Precipitation.SNOW && ParticleRainConfig.doSnowParticles) {
            if (level.random.nextFloat() < (float)ParticleRainConfig.SnowOptions.density / 100.0f) {
                level.addParticle((ParticleOptions)ParticleRegistry.SNOW.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (WeatherParticleSpawner.doesThisBlockHaveDustBlowing(precipitation, level, BlockPos.containing((double)x, (double)y, (double)z), biome)) {
            if (ParticleRainConfig.SandOptions.spawnOnGround) {
                y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z);
            }
            if (ParticleRainConfig.doSandParticles && level.random.nextFloat() < (float)ParticleRainConfig.SandOptions.density / 100.0f) {
                level.addParticle((ParticleOptions)ParticleRegistry.DUST.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            if (ParticleRainConfig.doShrubParticles && level.random.nextFloat() < (float)ParticleRainConfig.ShrubOptions.density / 100.0f) {
                level.addParticle((ParticleOptions)ParticleRegistry.SHRUB.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void update(ClientLevel level, Entity entity, float partialTicks) {
        if (level.isRaining() || ParticleRainConfig.alwaysRaining) {
            int density = level.isThundering() ? (ParticleRainConfig.alwaysRaining ? ParticleRainConfig.particleStormDensity : (int)((float)ParticleRainConfig.particleStormDensity * level.getRainLevel(partialTicks))) : (ParticleRainConfig.alwaysRaining ? ParticleRainConfig.particleDensity : (int)((float)ParticleRainConfig.particleDensity * level.getRainLevel(partialTicks)));
            RandomSource rand = RandomSource.create();
            for (int pass = 0; pass < density; ++pass) {
                float theta = (float)(Math.PI * 2 * (double)rand.nextFloat());
                float phi = (float)Math.acos(2.0f * rand.nextFloat() - 1.0f);
                double x = (double)((float)ParticleRainConfig.particleRadius * Mth.sin((float)phi)) * Math.cos(theta);
                double y = (double)((float)ParticleRainConfig.particleRadius * Mth.sin((float)phi)) * Math.sin(theta);
                double z = (float)ParticleRainConfig.particleRadius * Mth.cos((float)phi);
                pos.set(x + entity.getX(), y + entity.getY(), z + entity.getZ());
                if (level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ()) > pos.getY()) continue;
                WeatherParticleSpawner.spawnParticle(level, (Holder<Biome>)level.getBiome((BlockPos)pos), (float)pos.getX() + rand.nextFloat(), (float)pos.getY() + rand.nextFloat(), (float)pos.getZ() + rand.nextFloat());
            }
        }
    }

    @Nullable
    public static SoundEvent getBiomeSound(BlockPos blockPos, boolean above) {
        Holder biome = Minecraft.getInstance().level.getBiome(blockPos);
        Biome.Precipitation precipitation = ((Biome)biome.value()).getPrecipitationAt(blockPos);
        if (precipitation == Biome.Precipitation.RAIN && ParticleRainConfig.doRainSounds) {
            return above ? SoundEvents.WEATHER_RAIN_ABOVE : SoundEvents.WEATHER_RAIN;
        }
        if (precipitation == Biome.Precipitation.SNOW && ParticleRainConfig.doSnowSounds) {
            return above ? (SoundEvent)ParticleRegistry.WEATHER_SNOW_ABOVE.get() : (SoundEvent)ParticleRegistry.WEATHER_SNOW.get();
        }
        if (WeatherParticleSpawner.doesThisBlockHaveDustBlowing(precipitation, Minecraft.getInstance().level, blockPos, (Holder<Biome>)biome) && ParticleRainConfig.doSandSounds) {
            return above ? (SoundEvent)ParticleRegistry.WEATHER_SANDSTORM_ABOVE.get() : (SoundEvent)ParticleRegistry.WEATHER_SANDSTORM.get();
        }
        return null;
    }

    public static boolean doesThisBlockHaveDustBlowing(Biome.Precipitation precipitation, ClientLevel level, BlockPos blockPos, Holder<Biome> biome) {
        return precipitation == Biome.Precipitation.NONE && level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)ParticleRainConfig.SandOptions.matchTags))) && (double)((Biome)biome.value()).getBaseTemperature() > 0.25;
    }
}

