/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.octostudios.octolib.modules.config.ConfigManager;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class OctolibCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"octolib").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"config").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").then(Commands.literal((String)"all").executes(context -> {
            int counter = 0;
            for (String path : ConfigManager.getAllPaths()) {
                try {
                    ConfigManager.reload(path);
                    ++counter;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Error occurs while reload config by path ").append((Component)Component.literal((String)("\"" + path + "\""))));
                    return 0;
                }
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(counter + " configs reload successfully")));
            return 1;
        }))).then(Commands.argument((String)"path", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.suggest(ConfigManager.getAllPaths(), (SuggestionsBuilder)b)).executes(c -> {
            String path = StringArgumentType.getString((CommandContext)c, (String)"path");
            if (!ConfigManager.getAllPaths().contains(path)) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Config by path \"" + path + "\" does not exist")));
                return 0;
            }
            try {
                ConfigManager.reload(path);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Error occurs while reloading config by path ").append((Component)Component.literal((String)("\"" + path + "\""))));
                return 0;
            }
            return 1;
        })))));
    }
}

