/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.petemc.mutantszombies.entity.MutantBruteEntity;
import org.jetbrains.annotations.NotNull;

public class MutantBruteModel<T extends MutantBruteEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mutantszombies", (String)"mutant_brute"), "main");
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public MutantBruteModel(ModelPart root) {
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-23.0f, (float)-26.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 34).addBox(9.0f, -4.4971f, -8.5555f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 8).addBox(8.0f, -2.4971f, -8.5555f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 39).addBox(1.0f, -3.4971f, -8.5555f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(142, 107).addBox(-1.0f, -1.4971f, -9.5555f, 13.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)6.0f, (float)-3.0f, (float)0.2558f, (float)-0.0393f, (float)0.303f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.3946f, -9.0389f, -0.2208f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.0f, (float)10.0f, (float)-8.0f, (float)-0.006f, (float)-0.0393f, (float)0.303f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(33, 0).addBox(-0.5979f, -9.3484f, -1.0484f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)10.0f, (float)-4.0f, (float)0.2516f, (float)-0.0612f, (float)0.3876f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(4, 0).addBox(-0.6605f, -9.7518f, 0.0047f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)11.0f, (float)-10.0f, (float)0.2455f, (float)-0.0827f, (float)0.4724f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(27, 36).addBox(1.0f, -32.0f, -46.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(31, 36).addBox(-3.0f, -32.0f, -46.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 0).addBox(5.0f, -32.0f, -46.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 4).addBox(6.0f, -33.0f, -46.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(113, 50).addBox(-6.0f, -44.0f, -47.0f, 19.0f, 13.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)39.0f, (float)26.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition blisterhead = head.addOrReplaceChild("blisterhead", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)39.0f, (float)26.0f));
        PartDefinition cube_r6 = blisterhead.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(189, 189).addBox(10.0f, -35.0f, -46.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(134, 41).addBox(13.0f, -36.0f, -44.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(149, 0).addBox(11.0f, -45.0f, -42.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(70, 185).addBox(3.0f, -47.0f, -49.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(83, 75).addBox(7.0f, -48.0f, -48.0f, 7.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Minihead = head.addOrReplaceChild("Minihead", CubeListBuilder.create().texOffs(150, 25).addBox(-5.0f, -8.0f, -15.0f, 8.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(40, 7).addBox(-4.0f, 1.0f, -14.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.0f, (float)4.0f, (float)2.0f));
        PartDefinition cube_r7 = Minihead.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 41).addBox(3.0f, -0.6019f, -9.0736f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(4.0f, -1.6019f, -9.0736f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 37).addBox(-4.0f, -0.6019f, -3.0736f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(27, 29).addBox(-4.0f, -1.6019f, -6.0736f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(0.0f, -0.6019f, -9.0736f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-3.0f, 0.3981f, -10.0736f, 8.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)-5.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(79, 84).addBox(-16.0f, -49.0f, -15.0f, 13.0f, 21.0f, 37.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, -55.0f, -15.0f, 23.0f, 27.0f, 44.0f, new CubeDeformation(0.0f)).texOffs(0, 71).addBox(-13.0f, -38.0f, 4.0f, 25.0f, 17.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)-13.0f));
        PartDefinition blistertorso = torso.addOrReplaceChild("blistertorso", CubeListBuilder.create().texOffs(142, 84).addBox(10.0f, -40.0f, 21.0f, 12.0f, 10.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 121).addBox(14.0f, -43.0f, 29.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(17.0f, -42.0f, 29.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(90, 8).addBox(20.0f, -43.0f, 23.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 136).addBox(7.0f, -39.0f, 29.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(179, 84).addBox(17.0f, -39.0f, 29.0f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(172, 184).addBox(14.0f, -32.0f, 29.0f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(27, 29).addBox(18.0f, -31.0f, 26.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(90, 0).addBox(20.0f, -32.0f, 19.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition cube_r8 = blistertorso.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(179, 107).addBox(32.0f, -7.0f, -4.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 129).addBox(24.0f, 1.0f, -12.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(128, 180).addBox(28.0f, 0.0f, -15.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(150, 180).addBox(30.0f, -4.0f, -14.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(179, 120).addBox(34.0f, -5.0f, -8.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(47, 121).addBox(28.0f, -2.0f, 1.0f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(170, 133).addBox(28.0f, -8.0f, -12.0f, 9.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-35.0f, (float)-1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition bone = blistertorso.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = bone.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(83, 93).addBox(8.0f, -34.0f, 25.0f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 94).addBox(9.0f, -37.0f, 25.0f, 8.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(142, 84).addBox(9.0f, -40.0f, 19.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(122, 191).addBox(13.0f, -41.0f, 19.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(170, 171).addBox(4.0f, -38.0f, 21.0f, 11.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-16.0f, (float)-17.0f, (float)-19.0f));
        PartDefinition cube_r10 = right_arm.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 168).addBox(-4.0f, 0.0f, -3.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)6.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm2 = right_arm.addOrReplaceChild("left_arm2", CubeListBuilder.create(), PartPose.offset((float)-7.0f, (float)6.0f, (float)-3.0f));
        PartDefinition cube_r11 = left_arm2.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(40, 168).addBox(18.0f, 16.0f, 6.0f, 6.0f, 27.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-19.0f, (float)-8.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = left_arm2.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(120, 142).addBox(16.0f, -3.0f, -4.0f, 13.0f, 26.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-19.0f, (float)-8.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition blisterarm = right_arm.addOrReplaceChild("blisterarm", CubeListBuilder.create(), PartPose.offset((float)16.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition cube_r13 = blisterarm.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(106, 173).addBox(-18.0f, 14.0f, 7.0f, 3.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)20.0f, (float)-17.0f, (float)-15.0f));
        PartDefinition cube_r14 = left_arm.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(0, 121).addBox(14.0f, 11.0f, 2.0f, 16.0f, 32.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-20.0f, (float)-2.0f, (float)1.0f, (float)-0.1355f, (float)0.2595f, (float)-0.035f));
        PartDefinition cube_r15 = left_arm.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(90, 0).addBox(13.0f, -6.0f, -10.0f, 21.0f, 24.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-20.0f, (float)-2.0f, (float)1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition lfarmblister = left_arm.addOrReplaceChild("lfarmblister", CubeListBuilder.create().texOffs(142, 84).addBox(-7.6667f, -4.4444f, -7.6111f, 12.0f, 10.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 121).addBox(-3.6667f, -7.4444f, 0.3889f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-0.6667f, -6.4444f, 0.3889f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(179, 84).addBox(-0.6667f, -3.4444f, 0.3889f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(172, 184).addBox(-3.6667f, 3.5556f, 0.3889f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(27, 29).addBox(0.3333f, 4.5556f, -2.6111f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 136).addBox(-10.6667f, -3.4444f, 0.3889f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(90, 0).addBox(2.3333f, 3.5556f, -9.6111f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(90, 8).addBox(2.3333f, -7.4444f, -5.6111f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.6667f, (float)36.4444f, (float)3.6111f, (float)-2.6517f, (float)-0.1932f, (float)-0.102f));
        PartDefinition cube_r16 = lfarmblister.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(128, 180).addBox(-19.1562f, -4.8107f, -12.9969f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(150, 180).addBox(-17.1562f, -8.8107f, -11.9969f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(179, 120).addBox(-13.1562f, -9.8107f, -5.9969f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(179, 107).addBox(-15.1562f, -11.8107f, -1.9969f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.4896f, (float)24.8529f, (float)12.9747f, (float)0.8494f, (float)-0.5163f, (float)0.4707f));
        PartDefinition bone2 = left_arm.addOrReplaceChild("bone2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.5262f, (float)33.2f, (float)9.6814f, (float)-1.0036f, (float)0.3747f, (float)0.2291f));
        PartDefinition cube_r17 = bone2.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(83, 93).addBox(8.0f, -34.0f, 25.0f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 94).addBox(9.0f, -37.0f, 25.0f, 8.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(142, 84).addBox(9.0f, -40.0f, 19.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(122, 191).addBox(13.0f, -41.0f, 19.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(170, 171).addBox(4.0f, -38.0f, 21.0f, 11.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4738f, (float)35.8f, (float)-26.6814f, (float)0.0f, (float)-0.6545f, (float)0.0f));
        PartDefinition lfarmblister3 = left_arm.addOrReplaceChild("lfarmblister3", CubeListBuilder.create().texOffs(142, 84).addBox(-7.6667f, -4.4444f, -7.6111f, 12.0f, 10.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 121).addBox(-3.6667f, -7.4444f, 0.3889f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-0.6667f, -6.4444f, 0.3889f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(179, 84).addBox(-0.6667f, -3.4444f, 0.3889f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(172, 184).addBox(-3.6667f, 3.5556f, 0.3889f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(27, 29).addBox(0.3333f, 4.5556f, -2.6111f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 136).addBox(-10.6667f, -3.4444f, 0.3889f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(90, 0).addBox(2.3333f, 3.5556f, -9.6111f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(90, 8).addBox(2.3333f, -7.4444f, -5.6111f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.6667f, (float)33.4444f, (float)-5.3889f, (float)2.5406f, (float)-0.1932f, (float)-0.102f));
        PartDefinition lfarmblister2 = left_arm.addOrReplaceChild("lfarmblister2", CubeListBuilder.create().texOffs(170, 153).addBox(-3.0f, -4.4268f, -3.1669f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(172, 62).addBox(2.0f, -6.4268f, -0.1669f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(104, 142).addBox(-1.0f, 1.5732f, -5.1669f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)33.4268f, (float)-2.8331f, (float)0.0f, (float)1.5272f, (float)0.0f));
        PartDefinition cube_r18 = lfarmblister2.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(87, 190).addBox(8.0f, 6.0f, 3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(182, 24).addBox(7.0f, -2.0f, -4.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(30, 168).addBox(1.0f, 2.0f, -3.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.0f, (float)-3.4268f, (float)-3.1669f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition lfarmblister4 = left_arm.addOrReplaceChild("lfarmblister4", CubeListBuilder.create().texOffs(170, 153).addBox(-3.0f, -4.4268f, -3.1669f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(172, 62).addBox(2.0f, -6.4268f, -0.1669f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(104, 142).addBox(-1.0f, 1.5732f, -5.1669f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)26.4268f, (float)-2.8331f, (float)-1.0961f, (float)0.9286f, (float)-1.0832f));
        PartDefinition cube_r19 = lfarmblister4.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(87, 190).addBox(8.0f, 6.0f, 3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(182, 24).addBox(7.0f, -2.0f, -4.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(30, 168).addBox(1.0f, 2.0f, -3.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.0f, (float)-3.4268f, (float)-3.1669f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition bone3 = left_arm.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(170, 153).addBox(-4.8333f, -3.4754f, -6.1219f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(172, 62).addBox(0.1667f, -5.4754f, -6.1219f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8333f, (float)20.4754f, (float)9.1219f, (float)-0.2206f, (float)-0.3207f, (float)0.4994f));
        PartDefinition cube_r20 = bone3.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(172, 62).addBox(-5.0f, -2.0f, -2.5f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.1667f, (float)1.5246f, (float)-10.6219f, (float)0.0f, (float)1.4835f, (float)0.0f));
        PartDefinition cube_r21 = bone3.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(87, 190).addBox(8.0f, 6.0f, 3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.8333f, (float)-2.4754f, (float)-6.1219f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(70, 173).addBox(-5.0f, 22.0f, 1.0f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)12.0f, (float)-1.0f, (float)20.0f));
        PartDefinition cube_r22 = left_leg.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(166, 0).addBox(3.0f, -4.0f, -1.0f, 9.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)14.0f, (float)1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r23 = left_leg.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(62, 142).addBox(-4.0f, -6.6533f, -10.2527f, 13.0f, 15.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition blisterleg = left_leg.addOrReplaceChild("blisterleg", CubeListBuilder.create().texOffs(170, 153).addBox(8.0f, -1.0f, 0.0f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(172, 62).addBox(13.0f, -3.0f, 3.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(104, 142).addBox(10.0f, 5.0f, -2.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)14.0f, (float)1.0f));
        PartDefinition cube_r24 = blisterleg.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(87, 190).addBox(8.0f, 6.0f, 3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(182, 24).addBox(7.0f, -2.0f, -4.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(30, 168).addBox(1.0f, 2.0f, -3.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(172, 50).addBox(-4.0f, 24.0f, -6.0f, 8.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-13.0f, (float)-1.0f, (float)20.0f));
        PartDefinition cube_r25 = right_leg.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -24.0f, -4.0f, 11.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)17.0f, (float)-6.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r26 = right_leg.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(0, 71).addBox(-8.0f, -6.0f, 1.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)17.0f, (float)-6.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        int i = ((MutantBruteEntity)((Object)pEntity)).getAttackAnimationTick();
        if (i > 0) {
            this.right_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - pPartialTick), (float)10.0f);
            this.left_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - pPartialTick), (float)10.0f);
        } else {
            this.right_arm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)pLimbSwing, (float)13.0f)) * pLimbSwingAmount;
            this.left_arm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)pLimbSwing, (float)13.0f)) * pLimbSwingAmount;
        }
    }
}

