/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.petemc.mutantszombies.entity.BlisterZombieEntity;

public class BlisterZombieModel<T extends BlisterZombieEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mutantszombies", (String)"blister_zombie_layer"), "main");
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public BlisterZombieModel(ModelPart root) {
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)-9.0f));
        head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(42, 0).addBox(-3.0f, 0.0f, -8.0f, 6.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 22).addBox(-5.0f, -6.0f, -8.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition faceplates = head.addOrReplaceChild("faceplates", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-6.0f));
        faceplates.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(33, 0).addBox(0.5f, -1.0f, -5.0f, 0.5f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2057f, (float)0.3023f, (float)0.0186f));
        faceplates.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(63, 2).addBox(0.5f, -2.0f, -7.0f, 0.5f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.4983f, (float)0.7777f, (float)-0.5184f));
        faceplates.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(74, 36).addBox(0.0f, 0.0f, -7.0f, 1.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.6285f, (float)0.686f, (float)-1.2187f));
        faceplates.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(65, 80).addBox(0.0f, -2.0f, -7.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7475f, (float)0.5719f, (float)-0.2274f));
        faceplates.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(79, 81).addBox(0.5f, -2.0f, -7.0f, 0.5f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1589f, (float)-0.2725f, (float)0.2135f));
        faceplates.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(60, 27).addBox(0.0f, -4.0f, -10.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1622f, (float)-0.5334f, (float)-0.1392f));
        faceplates.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(21, 50).addBox(0.0f, -5.0f, -10.0f, 1.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-1.0036f, (float)0.0f));
        PartDefinition sidegrips = head.addOrReplaceChild("sidegrips", CubeListBuilder.create().texOffs(0, 72).addBox(5.0f, -1.0f, -5.0f, 0.5f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        sidegrips.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(46, 38).addBox(-5.5f, -1.0f, -9.0f, 0.5f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0173f, (float)0.192f, (float)-0.1791f));
        sidegrips.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(73, 0).addBox(-5.5f, -1.0f, -6.0f, 0.5f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.176f, (float)0.1289f, (float)-0.0229f));
        sidegrips.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(61, 43).addBox(-5.5f, -3.7f, -7.0f, 0.5f, 0.7f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        sidegrips.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(49, 14).addBox(5.0f, -1.0f, -10.0f, 0.5f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7591f, (float)-0.192f, (float)0.1791f));
        sidegrips.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(73, 70).addBox(5.0f, -4.0f, -7.0f, 0.5f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)1.0f));
        torso.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -13.9403f, -4.1423f, 12.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(30, 32).addBox(-4.0f, -14.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition backplates = torso.addOrReplaceChild("backplates", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)-1.0f));
        backplates.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(52, 58).addBox(2.0f, -7.0f, -2.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        backplates.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(63, 65).addBox(3.5f, -6.0f, -2.0f, 0.5f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)1.0472f, (float)0.0f));
        backplates.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(41, 51).addBox(-1.0f, -4.0f, -2.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)-0.0873f, (float)0.0f));
        backplates.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(0, 57).addBox(-2.5f, -7.0f, -8.0f, 0.5f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0057f, (float)0.0433f, (float)0.131f));
        backplates.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(47, 74).addBox(-3.75f, -3.0f, -2.0f, 0.75f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f));
        backplates.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(13, 67).addBox(2.5f, -1.0f, -2.0f, 0.5f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0607f, (float)0.116f, (float)-0.4835f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-4.0f, (float)-6.0f));
        left_arm.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(33, 67).addBox(1.0f, 3.8813f, -4.723f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)8.0f, (float)-5.0f, (float)1.5007f, (float)0.1367f, (float)0.6339f));
        left_arm.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(31, 11).addBox(0.0f, -2.0f, -11.0f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)1.5901f, (float)0.3093f, (float)-0.4295f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-4.0f, (float)-5.0f));
        right_arm.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(71, 20).addBox(-5.0f, -1.6187f, -4.723f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)8.0f, (float)-4.0f, (float)1.0898f, (float)-0.3133f, (float)-0.0098f));
        right_arm.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, -2.0f, -11.0f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)1.0f, (float)1.0036f, (float)0.0f, (float)0.5236f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(19, 38).addBox(0.0f, 6.0f, -8.0f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)12.0f, (float)1.0f));
        left_leg.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(74, 55).addBox(-6.0f, 0.3983f, -2.0908f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-1.0f, (float)0.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)12.0f, (float)1.0f));
        right_leg.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(0, 38).addBox(-6.0f, -7.0f, -2.0f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(29, 78).addBox(-5.0f, -0.5554f, -2.3915f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)-0.2612f, (float)0.2699f, (float)0.1488f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

