/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.reload;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;

public abstract class AbstractResourceReloadListener
implements PreparableReloadListener {
    public ResourceLocation getId() {
        String modId = this.getModId();
        String path = "%s-reload-listener".formatted(modId);
        return ResourceLocation.fromNamespaceAndPath((String)modId, (String)path);
    }

    public abstract String getModId();

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager manager, ProfilerFiller profiler, ProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return synchronizer.wait((Object)Unit.INSTANCE).thenRunAsync(() -> {
            profiler.push("listener");
            this.reloadStuff(synchronizer, manager, prepareExecutor, applyExecutor);
            profiler.pop();
        }, applyExecutor);
    }

    protected abstract void reloadStuff(PreparableReloadListener.PreparationBarrier var1, ResourceManager var2, Executor var3, Executor var4);
}

