/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.modmenu;

import net.lopymine.mossylib.client.MossyLibClient;
import net.lopymine.mossylib.loader.MossyLoader;
import net.lopymine.mossylib.modmenu.NoConfigLibraryScreen;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public abstract class AbstractModMenuIntegration {
    public void register(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, parent) -> {
            if (MossyLoader.isModLoaded("yet_another_config_lib_v3", false)) {
                ModContainer yacl = (ModContainer)ModList.get().getModContainerById("yet_another_config_lib_v3").orElseThrow();
                ArtifactVersion version = yacl.getModInfo().getVersion();
                try {
                    DefaultArtifactVersion requestsVersion = new DefaultArtifactVersion("3.8.0+1.21.1-neoforge");
                    if (version.compareTo((Object)requestsVersion) >= 0) {
                        return this.createConfigScreen(parent);
                    }
                }
                catch (Exception e) {
                    MossyLibClient.LOGGER.error("Failed to compare YACL version, tell mod author about this error: ", e);
                }
                return NoConfigLibraryScreen.createScreenAboutOldVersion(parent, version.getQualifier(), this.getModId());
            }
            return NoConfigLibraryScreen.createScreen(parent, this.getModId());
        }));
    }

    protected abstract String getModId();

    protected abstract Screen createConfigScreen(Screen var1);
}

