/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.loader;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.lopymine.mossylib.reload.AbstractResourceReloadListener;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.common.NeoForge;

public class MossyLoader {
    public static boolean isModLoaded(String modid, boolean loadingPhase) {
        if (loadingPhase) {
            return FMLLoader.getLoadingModList().getModFileById(modid) != null;
        }
        return ModList.get().isLoaded(modid);
    }

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static void registerReloadListener(AbstractResourceReloadListener listener) {
        IEventBus bus = ModLoadingContext.get().getActiveContainer().getEventBus();
        if (bus == null) {
            throw new IllegalArgumentException("Failed to get active mod bus to register reload listener");
        }
        bus.addListener(RegisterClientReloadListenersEvent.class, event -> event.registerReloadListener((PreparableReloadListener)listener));
    }

    public static void registerCommands(Consumer<CommandDispatcher<CommandSourceStack>> consumer) {
        NeoForge.EVENT_BUS.addListener(RegisterClientCommandsEvent.class, event -> consumer.accept(event.getDispatcher()));
    }
}

