/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.lopymine.ip.atlas.InventoryParticlesAtlasManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ParticleDrawUtils {
    @Nullable
    private static BufferBuilder PARTICLES_BUFFER = null;

    public static void drawParticleSprite(GuiGraphics context, TextureAtlasSprite sprite, int x, int y, float width, float height, int color) {
        if (PARTICLES_BUFFER == null) {
            return;
        }
        float x2 = (float)x + width;
        float y2 = (float)y + height;
        float z = 0.0f;
        float u1 = sprite.getU0();
        float u2 = sprite.getU1();
        float v1 = sprite.getV0();
        float v2 = sprite.getV1();
        Matrix4f matrix4f = context.pose().last().pose();
        PARTICLES_BUFFER.addVertex(matrix4f, (float)x, (float)y, z).setUv(u1, v1).setColor(color);
        PARTICLES_BUFFER.addVertex(matrix4f, (float)x, y2, z).setUv(u1, v2).setColor(color);
        PARTICLES_BUFFER.addVertex(matrix4f, x2, y2, z).setUv(u2, v2).setColor(color);
        PARTICLES_BUFFER.addVertex(matrix4f, x2, (float)y, z).setUv(u2, v1).setColor(color);
    }

    public static void prepareParticlesBuffer() {
        if (PARTICLES_BUFFER != null) {
            ParticleDrawUtils.endParticlesBuffer();
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryParticlesAtlasManager.ATLAS_ID);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        PARTICLES_BUFFER = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
    }

    public static void endParticlesBuffer() {
        if (PARTICLES_BUFFER == null) {
            return;
        }
        BufferUploader.drawWithShader((MeshData)PARTICLES_BUFFER.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        PARTICLES_BUFFER = null;
    }
}

