/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.utils;

import java.util.ArrayList;
import java.util.Optional;
import net.lopymine.ip.utils.ArgbUtils2;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;

public class NbtUtils {
    public static final Optional<Integer[]> NO_EFFECTS_COLOR = Optional.of(new Integer[]{-13083194});

    public static Optional<Integer[]> getColorsFromStack(ItemStack stack) {
        if (stack.is(Items.POTION) || stack.is(Items.LINGERING_POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.TIPPED_ARROW)) {
            return NbtUtils.getColorFromPotionContentsStack(stack);
        }
        if (stack.is(Items.CROSSBOW)) {
            return Optional.ofNullable((ChargedProjectiles)stack.getComponents().get(DataComponents.CHARGED_PROJECTILES)).map(ChargedProjectiles::getItems).filter(list -> !list.isEmpty()).map(list -> NbtUtils.getColorFromPotionContentsStack((ItemStack)list.get(0))).filter(Optional::isPresent).map(Optional::get);
        }
        if (stack.is(ItemTags.DYEABLE)) {
            return NbtUtils.getColorFromDyedStack(stack);
        }
        if (stack.is(Items.FIREWORK_STAR)) {
            return NbtUtils.getColorFromFireworkExplosionStack(stack);
        }
        if (stack.is(Items.FIREWORK_ROCKET)) {
            return NbtUtils.getColorFromFirework(stack);
        }
        return Optional.empty();
    }

    public static Optional<Integer[]> getColorFromFirework(ItemStack stack) {
        return Optional.ofNullable((Fireworks)stack.getComponents().get(DataComponents.FIREWORKS)).map(Fireworks::explosions).map(c -> (Integer[])c.stream().map(FireworkExplosion::colors).flatMap(o -> o.intStream().boxed()).toArray(Integer[]::new));
    }

    public static Optional<Integer[]> getColorFromFireworkExplosionStack(ItemStack stack) {
        return Optional.ofNullable((FireworkExplosion)stack.getComponents().get(DataComponents.FIREWORK_EXPLOSION)).map(NbtUtils::getColorFromFireworkExplosionStack);
    }

    private static Integer[] getColorFromFireworkExplosionStack(FireworkExplosion component) {
        Integer[] colors = new Integer[component.colors().size()];
        for (int i = 0; i < component.colors().size(); ++i) {
            colors[i] = NbtUtils.notZeroAlpha(component.colors().getInt(i));
        }
        return colors;
    }

    public static Optional<Integer[]> getColorFromPotionContentsStack(ItemStack stack) {
        Optional optional;
        PotionContents component = (PotionContents)stack.getComponents().get(DataComponents.POTION_CONTENTS);
        if (component != null && (optional = component.customColor()).isPresent()) {
            return Optional.of(new Integer[]{(Integer)optional.get()});
        }
        if (component == null) {
            return Optional.empty();
        }
        Iterable effects = component.getAllEffects();
        ArrayList colors = new ArrayList();
        effects.forEach(effect -> colors.add(NbtUtils.notZeroAlpha(((MobEffect)effect.getEffect().value()).getColor())));
        if (colors.isEmpty()) {
            return Optional.of(new Integer[]{-13083194});
        }
        return Optional.of((Integer[])colors.toArray(Integer[]::new));
    }

    /*
     * Exception decompiling
     */
    public static Optional<Integer[]> getColorFromDyedStack(ItemStack stack) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int notZeroAlpha(int color) {
        int alpha = ArgbUtils2.getAlpha(color);
        if (alpha == 0) {
            return ArgbUtils2.fullAlpha(color);
        }
        return color;
    }
}

