/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.t2o;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.t2o.Texture2Object;
import net.lopymine.ip.t2o.Texture2ObjectPixelFilter;
import net.lopymine.mossylib.loader.MossyLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class Texture2ObjectsManager {
    public static <T> List<T> readFromTexture(ResourceLocation id, String objectName, Texture2ObjectPixelFilter filter, Texture2Object<T> texture2Object) {
        try {
            Optional optional = Minecraft.getInstance().getResourceManager().getResource(id);
            if (optional.isEmpty()) {
                if (InventoryParticlesConfig.getInstance().getMainConfig().isDebugModeEnabled() || MossyLoader.isDevelopmentEnvironment()) {
                    InventoryParticlesClient.LOGGER.error("Failed to find texture from \"{}\" to create {} from texture!", new Object[]{id, objectName});
                }
                return List.of();
            }
            Resource resource = (Resource)optional.get();
            InputStream inputStream = resource.open();
            NativeImage image = NativeImage.read((InputStream)inputStream);
            ArrayList<T> list = new ArrayList<T>();
            int width = image.getWidth();
            int height = image.getHeight();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    T object;
                    int color = image.getPixelRGBA(x, y);
                    if (Boolean.FALSE.equals(filter.getFilter().accept(x, y, width, height, color)) || (object = texture2Object.accept(x, y, width, height, color)) == null) continue;
                    list.add(object);
                }
            }
            return list;
        }
        catch (Exception e) {
            InventoryParticlesClient.LOGGER.error("Failed to load create {} from texture \"{}\"! Reason:", new Object[]{id, e});
            return List.of();
        }
    }
}

