/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.renderer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.optimization.ParticleDeletionMode;
import net.lopymine.ip.config.sub.InventoryParticleConfig;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.element.InventoryParticle;
import net.lopymine.ip.element.base.IParticle;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.particles.ParticlesConfigsManager;
import net.lopymine.ip.spawner.IParticleSpawner;
import net.lopymine.ip.spawner.context.ParticleSpawnContext;
import net.lopymine.ip.utils.ParticleDrawUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryParticlesRenderer
extends TickElement {
    private static final InventoryParticlesRenderer INSTANCE = new InventoryParticlesRenderer();
    private final Collection<IParticle> screenParticles = InventoryParticlesRenderer.getScreenParticlesList();
    private final List<IParticle> pendingParticles = new ArrayList<IParticle>();
    private final RandomSource random = RandomSource.create();
    private InventoryCursor cursor = new InventoryCursor();
    private boolean stoppedByInitializationReason;
    private boolean stoppedTicking;
    private int ticksPerTick = 1;
    private int nextTick = 1;
    @Nullable
    private IParticle hoveredParticle;
    @Nullable
    private IParticle selectedParticle;

    private InventoryParticlesRenderer() {
    }

    public static InventoryParticlesRenderer getInstance() {
        return INSTANCE;
    }

    public void render(GuiGraphics context, float tickProgress) {
        this.hoveredParticle = null;
        if (this.screenParticles.isEmpty()) {
            return;
        }
        this.runSoft(() -> {
            ParticleDrawUtils.prepareParticlesBuffer();
            for (IParticle particle : this.screenParticles) {
                if (particle == null) continue;
                particle.render(context, this.cursor, tickProgress, this.isStoppedTicking());
                if (!particle.isHovered()) continue;
                this.hoveredParticle = particle;
            }
            ParticleDrawUtils.endParticlesBuffer();
        }, "rendering_particle");
    }

    public void tick(@Nullable AbstractContainerMenu handler, @Nullable Integer inventoryX, @Nullable Integer inventoryY) {
        if (this.stoppedTicking || this.stoppedByInitializationReason) {
            return;
        }
        super.tick();
        if (this.ticks < this.nextTick) {
            return;
        }
        this.nextTick = this.ticks + this.ticksPerTick;
        this.runSoft(() -> {
            this.cursor.tick();
            InventoryParticleConfig config = InventoryParticlesConfig.getInstance().getParticleConfig();
            if (config.isGuiSlotsSpawnEnabled() && inventoryX != null && inventoryY != null && handler != null) {
                this.spawnAllSlotsParticles(handler, inventoryX, inventoryY);
            }
            if (config.isHoveredSlotSpawnEnabled() && inventoryX != null && inventoryY != null) {
                this.spawnHoveredSlotParticles(inventoryX, inventoryY);
            }
            if (config.isCursorSpawnEnabled()) {
                this.spawnCursorParticles();
            }
            this.pushPendingParticles();
            this.screenParticles.removeIf(particle -> {
                if (particle == null) {
                    return true;
                }
                particle.tick();
                return particle.isDead() && !particle.isSelected();
            });
        }, "ticking_inventory_particles");
    }

    private void pushPendingParticles() {
        this.screenParticles.addAll(this.pendingParticles);
        this.pendingParticles.clear();
    }

    private void spawnHoveredSlotParticles(int inventoryX, int inventoryY) {
        Slot hoveredSlot = this.cursor.getHoveredSlot();
        if (hoveredSlot == null) {
            return;
        }
        ItemStack stack = hoveredSlot.getItem();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        List<IParticleSpawner> spawners = ParticlesConfigsManager.getSpawnersForItem(item);
        if (spawners == null) {
            return;
        }
        ParticleSpawnContext context = ParticleSpawnContext.hoveredSlot(hoveredSlot, inventoryX, inventoryY);
        for (IParticleSpawner spawner : spawners) {
            for (InventoryParticle particle : spawner.tickAndSpawn(context)) {
                this.spawnParticle(particle);
            }
        }
    }

    private void spawnAllSlotsParticles(AbstractContainerMenu handler, int inventoryX, int inventoryY) {
        for (Slot slot : handler.slots) {
            List<IParticleSpawner> particleSpawners;
            ItemStack stack;
            if (this.cursor.getHoveredSlot() != null && this.cursor.getHoveredSlot().index == slot.index || (stack = slot.getItem()).isEmpty() || (particleSpawners = ParticlesConfigsManager.getSpawnersForItem(stack.getItem())) == null) continue;
            ParticleSpawnContext context = ParticleSpawnContext.slots(slot, inventoryX, inventoryY);
            for (IParticleSpawner spawner : particleSpawners) {
                for (InventoryParticle particle : spawner.tickAndSpawn(context)) {
                    this.spawnParticle(particle);
                }
            }
        }
    }

    private void spawnCursorParticles() {
        ItemStack stack = this.cursor.getCurrentStack();
        if (stack.isEmpty()) {
            return;
        }
        List<IParticleSpawner> particleSpawners = ParticlesConfigsManager.getSpawnersForItem(stack.getItem());
        if (particleSpawners != null) {
            ArrayList<InventoryParticle> particles = new ArrayList<InventoryParticle>();
            for (IParticleSpawner spawner : particleSpawners) {
                particles.addAll(spawner.tickAndSpawn(ParticleSpawnContext.cursor(this.cursor)));
                particles.addAll(spawner.spawnFromCursor(this.cursor));
            }
            particles.forEach(this::spawnParticle);
        }
    }

    public void spawnParticle(IParticle particle) {
        InventoryParticlesConfig config = InventoryParticlesConfig.getInstance();
        int difference = this.screenParticles.size() + 1 - config.getParticleConfig().getMaxParticles();
        if (difference > 0) {
            this.clearParticlesForNewOnes(difference, config.getParticleConfig().getParticleDeletionMode());
        }
        this.pendingParticles.add(particle);
    }

    private void clearParticlesForNewOnes(int difference, ParticleDeletionMode mode) {
        switch (mode) {
            case OLDEST: {
                Collection<IParticle> collection = this.screenParticles;
                if (!(collection instanceof ArrayDeque)) {
                    return;
                }
                ArrayDeque deque = (ArrayDeque)collection;
                for (int i = 0; i < difference; ++i) {
                    deque.pollFirst();
                }
                break;
            }
            case RANDOM: {
                Collection<IParticle> i = this.screenParticles;
                if (!(i instanceof ArrayList)) {
                    return;
                }
                ArrayList list = (ArrayList)i;
                for (int i2 = 0; i2 < difference; ++i2) {
                    list.remove(this.random.nextIntBetweenInclusive(0, list.size() - 1));
                }
                break;
            }
        }
    }

    public void clear() {
        this.screenParticles.clear();
        this.pendingParticles.clear();
        this.hoveredParticle = null;
        this.selectedParticle = null;
        this.stoppedByInitializationReason = true;
    }

    public void init() {
        this.cursor = new InventoryCursor();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos() * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight();
        this.cursor.setMouseX(mouseX);
        this.cursor.setX(mouseX);
        this.cursor.setLastX(mouseX);
        this.cursor.setMouseY(mouseY);
        this.cursor.setY(mouseY);
        this.cursor.setLastY(mouseY);
        this.stoppedByInitializationReason = false;
    }

    public void mouseClicked(int button) {
        if (button != 1) {
            return;
        }
        if (!this.isStoppedTicking()) {
            return;
        }
        if (this.selectedParticle != null) {
            this.selectedParticle.setSelected(false);
            this.selectedParticle = null;
            this.playClickSound();
            return;
        }
        if (this.hoveredParticle == null) {
            return;
        }
        this.hoveredParticle.setSelected(true);
        this.selectedParticle = this.hoveredParticle;
        this.playClickSound();
    }

    private void playClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public void updateParticlesPositions(double xCoefficient, double yCoefficient) {
        for (IParticle particle : this.screenParticles) {
            particle.setX(particle.getX() * xCoefficient);
            particle.setY(particle.getY() * yCoefficient);
        }
        for (IParticle particle : this.pendingParticles) {
            particle.setX(particle.getX() * xCoefficient);
            particle.setY(particle.getY() * yCoefficient);
        }
    }

    private void runSoft(Runnable runnable, String action) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                MutableComponent text = Component.literal((String)"[%s] ".formatted("Inventory Particles")).append((Component)Component.literal((String)"Unexpected error with id \"%s\", please report this issue with your game logs! Mod was automatically disabled to prevent spamming ^^".formatted(action)).withStyle(ChatFormatting.RED));
                player.displayClientMessage((Component)text, false);
            }
            InventoryParticlesClient.LOGGER.error("[{}] Failed to process inventory particles!", new Object[]{action, e});
            InventoryParticlesConfig config = InventoryParticlesConfig.getInstance();
            config.getMainConfig().setModEnabled(false);
            config.saveAsync();
        }
    }

    public void onGuiAction(Slot slot, ItemStack stack, int inventoryX, int inventoryY) {
        if (stack.isEmpty() && !slot.hasItem()) {
            return;
        }
        int chanceOfSpawn = 100 - (int)Math.ceil(InventoryParticlesConfig.getInstance().getCoefficientsConfig().getGuiActionConfig().getCooldownCoefficient());
        int r = this.random.nextIntBetweenInclusive(0, 100);
        if (r < chanceOfSpawn) {
            return;
        }
        this.runSoft(() -> {
            List<IParticleSpawner> spawners = ParticlesConfigsManager.getSpawnersForItem(stack.isEmpty() ? slot.getItem().getItem() : stack.getItem());
            if (spawners != null) {
                ParticleSpawnContext context = ParticleSpawnContext.guiActionSlot(slot, inventoryX, inventoryY);
                if (context.getStack().isEmpty()) {
                    context.setStack(stack);
                }
                for (IParticleSpawner spawner : spawners) {
                    for (InventoryParticle particle : spawner.spawn(context)) {
                        this.spawnParticle(particle);
                    }
                }
            }
        }, "put_in_slot");
    }

    @NotNull
    private static Collection<IParticle> getScreenParticlesList() {
        return switch (InventoryParticlesConfig.getInstance().getParticleConfig().getParticleDeletionMode()) {
            default -> throw new MatchException(null, null);
            case ParticleDeletionMode.OLDEST -> new ArrayDeque();
            case ParticleDeletionMode.RANDOM -> new ArrayList();
        };
    }

    @Generated
    public List<IParticle> getPendingParticles() {
        return this.pendingParticles;
    }

    @Generated
    public RandomSource getRandom() {
        return this.random;
    }

    @Generated
    public InventoryCursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean isStoppedByInitializationReason() {
        return this.stoppedByInitializationReason;
    }

    @Generated
    public boolean isStoppedTicking() {
        return this.stoppedTicking;
    }

    @Generated
    public int getTicksPerTick() {
        return this.ticksPerTick;
    }

    @Generated
    public int getNextTick() {
        return this.nextTick;
    }

    @Nullable
    @Generated
    public IParticle getHoveredParticle() {
        return this.hoveredParticle;
    }

    @Nullable
    @Generated
    public IParticle getSelectedParticle() {
        return this.selectedParticle;
    }

    @Generated
    public void setCursor(InventoryCursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public void setStoppedByInitializationReason(boolean stoppedByInitializationReason) {
        this.stoppedByInitializationReason = stoppedByInitializationReason;
    }

    @Generated
    public void setStoppedTicking(boolean stoppedTicking) {
        this.stoppedTicking = stoppedTicking;
    }

    @Generated
    public void setTicksPerTick(int ticksPerTick) {
        this.ticksPerTick = ticksPerTick;
    }

    @Generated
    public void setNextTick(int nextTick) {
        this.nextTick = nextTick;
    }

    @Generated
    public void setHoveredParticle(@Nullable IParticle hoveredParticle) {
        this.hoveredParticle = hoveredParticle;
    }

    @Generated
    public void setSelectedParticle(@Nullable IParticle selectedParticle) {
        this.selectedParticle = selectedParticle;
    }

    @Generated
    public Collection<IParticle> getScreenParticles() {
        return this.screenParticles;
    }
}

