/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.particles;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.lopymine.ip.atlas.InventoryParticlesAtlasManager;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.misc.CachedItem;
import net.lopymine.ip.config.particle.ParticleConfig;
import net.lopymine.ip.config.particle.ParticleHolder;
import net.lopymine.ip.spawner.IParticleSpawner;
import net.lopymine.ip.spawner.ParticleSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class ParticlesConfigsManager {
    private static final Map<ParticleHolder, RegisteredConfig> REGISTERED_CONFIGS = new HashMap<ParticleHolder, RegisteredConfig>();
    private static final Map<Item, List<IParticleSpawner>> PER_ITEM_PARTICLE_SPAWNERS = new IdentityHashMap<Item, List<IParticleSpawner>>();
    private static final Map<TagKey<Item>, List<IParticleSpawner>> PER_TAG_PARTICLE_SPAWNERS = new HashMap<TagKey<Item>, List<IParticleSpawner>>();
    private static final Map<Item, List<IParticleSpawner>> COMBINED_MAP = new IdentityHashMap<Item, List<IParticleSpawner>>();

    public static void reload() {
        PER_ITEM_PARTICLE_SPAWNERS.clear();
        PER_TAG_PARTICLE_SPAWNERS.clear();
        InventoryParticlesClient.LOGGER.info("Started registering particle configs from resources...", new Object[0]);
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        AtomicInteger foundConfigs = new AtomicInteger();
        AtomicInteger registeredConfigs = new AtomicInteger();
        resourceManager.listResources(InventoryParticlesAtlasManager.FOLDER_ID.getPath(), id -> id.getPath().endsWith(".json5") || id.getPath().endsWith("json")).forEach((id, resource) -> {
            foundConfigs.getAndIncrement();
            try (InputStream inputStream = resource.open();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                ParticleConfig config = (ParticleConfig)((Pair)ParticleConfig.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow()).getFirst();
                for (ParticleHolder holder : config.getHolders()) {
                    ParticleSpawner spawner = holder.create(config::createParticle);
                    Either<CachedItem, ResourceLocation> itemOrTag = holder.getItemOrTag();
                    itemOrTag.ifLeft(cachedItem -> {
                        Item item = cachedItem.getItem();
                        ParticlesConfigsManager.registerItemSpawner(id, item, holder, (IParticleSpawner)spawner);
                    });
                    itemOrTag.ifRight(tag -> {
                        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag);
                        ParticlesConfigsManager.registerItemSpawner(id, (TagKey<Item>)tagKey, holder, (IParticleSpawner)spawner);
                    });
                }
                InventoryParticlesClient.LOGGER.debug("Registered config at \"{}\"", new Object[]{id});
                registeredConfigs.getAndIncrement();
            }
            catch (Exception e) {
                InventoryParticlesClient.LOGGER.error("Failed to parse particle config from \"{}\"! Reason:", new Object[]{id, e});
            }
        });
        InventoryParticlesClient.LOGGER.info("Registering finished, found: {}, registered: {}", new Object[]{foundConfigs.get(), registeredConfigs.get()});
    }

    public static void registerItemSpawner(ResourceLocation location, Item item, ParticleHolder holder, IParticleSpawner spawner) {
        PER_ITEM_PARTICLE_SPAWNERS.computeIfAbsent(item, i -> new ArrayList()).add(spawner);
        REGISTERED_CONFIGS.put(holder, new RegisteredConfig(location, spawner));
    }

    public static void registerItemSpawner(ResourceLocation location, TagKey<Item> item, ParticleHolder holder, IParticleSpawner spawner) {
        PER_TAG_PARTICLE_SPAWNERS.computeIfAbsent(item, i -> new ArrayList()).add(spawner);
        REGISTERED_CONFIGS.put(holder, new RegisteredConfig(location, spawner));
    }

    public static void updateCombinedMap() {
        COMBINED_MAP.clear();
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            ResourceLocation identifier = ((ResourceKey)entry.getKey()).location();
            Item item = (Item)entry.getValue();
            ArrayList<IParticleSpawner> spawners = new ArrayList<IParticleSpawner>();
            List<IParticleSpawner> itemSpecificSpawners = PER_ITEM_PARTICLE_SPAWNERS.get(item);
            if (itemSpecificSpawners != null) {
                spawners.addAll(itemSpecificSpawners);
            }
            if (!identifier.getNamespace().equals("minecraft")) {
                spawners.addAll(item.builtInRegistryHolder().tags().map(PER_TAG_PARTICLE_SPAWNERS::get).filter(Objects::nonNull).flatMap(Collection::stream).toList());
            }
            if (spawners.isEmpty()) continue;
            COMBINED_MAP.put(item, spawners);
        }
    }

    public static Map<ParticleHolder, RegisteredConfig> getRegisteredConfigs() {
        return REGISTERED_CONFIGS;
    }

    @Nullable
    public static List<IParticleSpawner> getSpawnersForItem(Item item) {
        return COMBINED_MAP.get(item);
    }

    public record RegisteredConfig(ResourceLocation id, IParticleSpawner spawner) {
    }
}

