/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.mixin;

import com.mojang.blaze3d.platform.Window;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.renderer.InventoryParticlesRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public abstract class MouseMixin {
    @Shadow
    private double xpos;
    @Shadow
    private double ypos;

    @Inject(at={@At(value="TAIL")}, method={"onMove"})
    private void updateMousePosition(CallbackInfo ci) {
        InventoryCursor cursor = InventoryParticlesRenderer.getInstance().getCursor();
        Window window = Minecraft.getInstance().getWindow();
        cursor.setMouseX((int)(this.xpos * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth()));
        cursor.setMouseY((int)(this.ypos * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight()));
    }

    @Inject(at={@At(value="TAIL")}, method={"onPress"})
    private void inject(CallbackInfo ci) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen handledScreen = (AbstractContainerScreen)screen;
            InventoryCursor cursor = InventoryParticlesRenderer.getInstance().getCursor();
            cursor.setCurrentStack(handledScreen.getMenu().getCarried());
        }
    }
}

