/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.lopymine.ip.atlas.InventoryParticlesAtlasManager;
import net.lopymine.ip.utils.MissingSpriteUtils;
import net.lopymine.ip.utils.mixin.IAtlasLoaderMixin;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteSourceList.class})
public class AtlasLoaderMixin
implements IAtlasLoaderMixin {
    @Unique
    private boolean inventoryParticles$marked;

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V", shift=At.Shift.AFTER)}, method={"list"}, cancellable=true)
    private void swapMissingTexture(CallbackInfoReturnable<List<Function<SpriteResourceLoader, SpriteContents>>> cir, @Local Map<ResourceLocation, SpriteSource.SpriteSupplier> map) {
        if (!this.inventoryParticles$marked) {
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(opener -> MissingSpriteUtils.getMissingParticle());
        builder.addAll(map.values());
        cir.setReturnValue((Object)builder.build());
    }

    @Override
    public void inventoryParticles$mark() {
        this.inventoryParticles$marked = true;
    }

    @WrapOperation(at={@At(value="NEW", target="(Ljava/util/List;)Lnet/minecraft/client/renderer/texture/atlas/SpriteSourceList;")}, method={"load"})
    private static SpriteSourceList markAtlas(List<SpriteSourceList> sources, Operation<SpriteSourceList> original, @Local(argsOnly=true) ResourceLocation path) {
        SpriteSourceList loader = (SpriteSourceList)original.call(new Object[]{sources});
        if (InventoryParticlesAtlasManager.FOLDER_ID.equals((Object)path)) {
            ((IAtlasLoaderMixin)loader).inventoryParticles$mark();
        }
        return loader;
    }
}

