/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.element;

import lombok.Generated;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.particle.ParticleConfig;
import net.lopymine.ip.config.particle.ParticlePhysics;
import net.lopymine.ip.config.particle.StaticParticleSize;
import net.lopymine.ip.controller.color.ColorController;
import net.lopymine.ip.controller.modifier.speed.SpeedInAngleDirectionControllerModifier;
import net.lopymine.ip.controller.size.DynamicSizeController;
import net.lopymine.ip.controller.speed.RotationSpeedController;
import net.lopymine.ip.controller.speed.SpeedController;
import net.lopymine.ip.debug.HideInDebugRender;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.element.base.IParticle;
import net.lopymine.ip.element.base.IRandomizable;
import net.lopymine.ip.element.base.IRepaintable;
import net.lopymine.ip.element.base.IResizableElement;
import net.lopymine.ip.element.base.IRotatableElement;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.spawner.context.ParticleSpawnContext;
import net.lopymine.ip.texture.IParticleTextureProvider;
import net.lopymine.ip.utils.ArgbUtils2;
import net.lopymine.ip.utils.ParticleDrawUtils;
import net.lopymine.mossylib.extension.DrawContextExtension;
import net.lopymine.mossylib.utils.ArgbUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryParticle
extends TickElement
implements IParticle,
IRotatableElement,
IRepaintable,
IRandomizable,
IResizableElement {
    @HideInDebugRender
    private final RandomSource random = RandomSource.create();
    private int lifeTimeTicks;
    private double standardParticleAngle;
    private double standardTextureAngle;
    private IParticleTextureProvider textureProvider;
    @Nullable
    private ColorController<InventoryParticle> colorController;
    private DynamicSizeController<InventoryParticle> dynamicSizeController;
    private SpeedController<InventoryParticle> xSpeedController;
    private SpeedController<InventoryParticle> ySpeedController;
    private RotationSpeedController<InventoryParticle> particleRotationSpeedController;
    private RotationSpeedController<InventoryParticle> textureRotationSpeedController;
    @NotNull
    private TextureAtlasSprite texture;
    private int color = -1;
    private double lastWidth = StaticParticleSize.STANDARD_SIZE.getWidth();
    private double lastHeight = StaticParticleSize.STANDARD_SIZE.getHeight();
    private double width = StaticParticleSize.STANDARD_SIZE.getWidth();
    private double height = StaticParticleSize.STANDARD_SIZE.getHeight();
    private double lastX;
    private double lastY;
    private double x;
    private double y;
    private double speedX;
    private double speedY;
    private double lastParticleAngle;
    private double particleAngle;
    private double lastTextureAngle;
    private double textureAngle;
    private boolean dead;
    private boolean selected;
    private boolean hovered;

    public InventoryParticle(ParticleConfig config, ParticleSpawnContext context) {
        this.lifeTimeTicks = config.getLifeTimeTicks();
        this.textureProvider = IParticleTextureProvider.getTextureProvider(config);
        this.texture = this.textureProvider.getInitializationTexture(this.random);
        this.dynamicSizeController = new DynamicSizeController<InventoryParticle>(config.getSize(), this);
        this.lastX = this.x = context.getX();
        this.lastY = this.y = context.getY();
        ParticlePhysics physics = config.getPhysics();
        ParticlePhysics.BasePhysics base = physics.getBase();
        ParticlePhysics.RotationSpeedPhysics rotation = physics.getRotation();
        this.standardParticleAngle = rotation.getParticleRotationConfig().getSpawnAngle().getRandom(this.random);
        this.particleAngle = 0.0;
        this.standardTextureAngle = rotation.getTextureRotationConfig().getSpawnAngle().getRandom(this.random);
        this.textureAngle = 0.0;
        this.xSpeedController = new SpeedController(base.getXSpeed(), this.random, context.getImpulseX());
        this.xSpeedController.registerModifier(new SpeedInAngleDirectionControllerModifier(base.getAngleSpeed(), this.random, true), true, this);
        this.ySpeedController = new SpeedController(base.getYSpeed(), this.random, context.getImpulseY());
        this.ySpeedController.registerModifier(new SpeedInAngleDirectionControllerModifier(base.getAngleSpeed(), this.random, false), true, this);
        this.particleRotationSpeedController = new RotationSpeedController(rotation.getParticleRotationConfig(), this.random);
        this.textureRotationSpeedController = new RotationSpeedController(rotation.getTextureRotationConfig(), this.random);
    }

    @Override
    public void tick() {
        if (this.isDead()) {
            return;
        }
        super.tick();
        this.textureProvider.tick();
        this.texture = this.textureProvider.getTexture(this.random);
        if (this.textureProvider.isShouldDead() || this.ticks > this.getLifeTimeTicks()) {
            this.dead = true;
            return;
        }
        if (this.colorController != null) {
            this.colorController.tick(this);
        }
        this.dynamicSizeController.tick(this);
        this.particleRotationSpeedController.tick(this);
        this.lastParticleAngle = this.particleAngle;
        this.particleAngle = this.particleRotationSpeedController.isRotateInMovementDirection() ? this.particleRotationSpeedController.getRotation() : (this.particleAngle + this.particleRotationSpeedController.getSpeed()) % 360.0;
        this.textureRotationSpeedController.tick(this);
        this.lastTextureAngle = this.textureAngle;
        this.textureAngle = this.textureRotationSpeedController.isRotateInMovementDirection() ? this.textureRotationSpeedController.getRotation() : (this.textureAngle + this.textureRotationSpeedController.getSpeed()) % 360.0;
        this.xSpeedController.tick(this);
        this.ySpeedController.tick(this);
        this.speedX = this.xSpeedController.getSpeed();
        this.speedY = this.ySpeedController.getSpeed();
        this.lastX = this.x;
        this.x += this.speedX;
        this.lastY = this.y;
        this.y += this.speedY;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen != null) {
            int width = currentScreen.width;
            int height = currentScreen.height;
            double d = (float)width / 4.0f;
            double v = (float)height / 4.0f;
            if (this.x < -d || this.y < -v || this.x > (double)width + d || this.y > (double)height + v) {
                this.dead = true;
            }
        }
    }

    @Override
    public void render(GuiGraphics context, InventoryCursor cursor, float tickProgress, boolean stoppedTicking) {
        float renderWidth = stoppedTicking ? (float)this.width : (float)Mth.lerp((double)tickProgress, (double)this.lastWidth, (double)this.width);
        float renderHeight = stoppedTicking ? (float)this.height : (float)Mth.lerp((double)tickProgress, (double)this.lastHeight, (double)this.height);
        float x = stoppedTicking ? (float)this.x : (float)Mth.lerp((double)tickProgress, (double)this.lastX, (double)this.x);
        float y = stoppedTicking ? (float)this.y : (float)Mth.lerp((double)tickProgress, (double)this.lastY, (double)this.y);
        this.updateHovered(cursor, x, y, renderWidth, renderHeight);
        boolean bl = stoppedTicking && this.isHovered() || this.isSelected();
        int m = bl ? 2 : 1;
        float width = renderWidth * (float)m;
        float halfWidth = width / 2.0f;
        float height = renderHeight * (float)m;
        float halfHeight = height / 2.0f;
        DrawContextExtension.push((GuiGraphics)context);
        DrawContextExtension.translate((GuiGraphics)context, (float)x, (float)y, (float)300.0f);
        if (bl) {
            DrawContextExtension.translate((GuiGraphics)context, (float)(-halfWidth / 2.0f), (float)(-halfHeight / 2.0f), (float)0.0f);
        }
        DrawContextExtension.translate((GuiGraphics)context, (float)halfWidth, (float)halfHeight, (float)0.0f);
        DrawContextExtension.rotateZ((GuiGraphics)context, (float)((float)(this.standardTextureAngle + this.textureAngle) % 360.0f));
        DrawContextExtension.translate((GuiGraphics)context, (float)(-halfWidth), (float)(-halfHeight), (float)0.0f);
        ParticleDrawUtils.drawParticleSprite(context, this.texture, 0, 0, width, height, this.getRenderColor());
        DrawContextExtension.pop((GuiGraphics)context);
    }

    private int getRenderColor() {
        int configAlpha;
        int alpha = ArgbUtils.getAlpha((int)this.color);
        if (alpha <= (configAlpha = (int)(InventoryParticlesConfig.getInstance().getParticleConfig().getParticleTransparency() * 255.0))) {
            return this.color;
        }
        return ArgbUtils2.getArgb(configAlpha, ArgbUtils2.getRed(this.color), ArgbUtils2.getGreen(this.color), ArgbUtils2.getBlue(this.color));
    }

    @Override
    public double getAngle() {
        return this.standardParticleAngle + this.particleAngle;
    }

    @Override
    public void setAngle(double degrees) {
        this.particleAngle = degrees;
    }

    @Override
    public void setWidth(double width) {
        this.lastWidth = this.width;
        this.width = width;
    }

    @Override
    public void setHeight(double height) {
        this.lastHeight = this.height;
        this.height = height;
    }

    @Generated
    public void setLifeTimeTicks(int lifeTimeTicks) {
        this.lifeTimeTicks = lifeTimeTicks;
    }

    @Generated
    public void setStandardParticleAngle(double standardParticleAngle) {
        this.standardParticleAngle = standardParticleAngle;
    }

    @Generated
    public void setStandardTextureAngle(double standardTextureAngle) {
        this.standardTextureAngle = standardTextureAngle;
    }

    @Generated
    public void setTextureProvider(IParticleTextureProvider textureProvider) {
        this.textureProvider = textureProvider;
    }

    @Generated
    public void setColorController(@Nullable ColorController<InventoryParticle> colorController) {
        this.colorController = colorController;
    }

    @Generated
    public void setDynamicSizeController(DynamicSizeController<InventoryParticle> dynamicSizeController) {
        this.dynamicSizeController = dynamicSizeController;
    }

    @Generated
    public void setXSpeedController(SpeedController<InventoryParticle> xSpeedController) {
        this.xSpeedController = xSpeedController;
    }

    @Generated
    public void setYSpeedController(SpeedController<InventoryParticle> ySpeedController) {
        this.ySpeedController = ySpeedController;
    }

    @Generated
    public void setParticleRotationSpeedController(RotationSpeedController<InventoryParticle> particleRotationSpeedController) {
        this.particleRotationSpeedController = particleRotationSpeedController;
    }

    @Generated
    public void setTextureRotationSpeedController(RotationSpeedController<InventoryParticle> textureRotationSpeedController) {
        this.textureRotationSpeedController = textureRotationSpeedController;
    }

    @Generated
    public void setTexture(@NotNull TextureAtlasSprite texture) {
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        this.texture = texture;
    }

    @Override
    @Generated
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    @Generated
    public void setLastWidth(double lastWidth) {
        this.lastWidth = lastWidth;
    }

    @Override
    @Generated
    public void setLastHeight(double lastHeight) {
        this.lastHeight = lastHeight;
    }

    @Generated
    public void setLastX(double lastX) {
        this.lastX = lastX;
    }

    @Generated
    public void setLastY(double lastY) {
        this.lastY = lastY;
    }

    @Override
    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Override
    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Override
    @Generated
    public void setSpeedX(double speedX) {
        this.speedX = speedX;
    }

    @Override
    @Generated
    public void setSpeedY(double speedY) {
        this.speedY = speedY;
    }

    @Generated
    public void setLastParticleAngle(double lastParticleAngle) {
        this.lastParticleAngle = lastParticleAngle;
    }

    @Generated
    public void setParticleAngle(double particleAngle) {
        this.particleAngle = particleAngle;
    }

    @Generated
    public void setLastTextureAngle(double lastTextureAngle) {
        this.lastTextureAngle = lastTextureAngle;
    }

    @Generated
    public void setTextureAngle(double textureAngle) {
        this.textureAngle = textureAngle;
    }

    @Generated
    public void setDead(boolean dead) {
        this.dead = dead;
    }

    @Override
    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    @Generated
    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    @Override
    @Generated
    public RandomSource getRandom() {
        return this.random;
    }

    @Generated
    public int getLifeTimeTicks() {
        return this.lifeTimeTicks;
    }

    @Generated
    public double getStandardParticleAngle() {
        return this.standardParticleAngle;
    }

    @Generated
    public double getStandardTextureAngle() {
        return this.standardTextureAngle;
    }

    @Generated
    public IParticleTextureProvider getTextureProvider() {
        return this.textureProvider;
    }

    @Nullable
    @Generated
    public ColorController<InventoryParticle> getColorController() {
        return this.colorController;
    }

    @Generated
    public DynamicSizeController<InventoryParticle> getDynamicSizeController() {
        return this.dynamicSizeController;
    }

    @Generated
    public SpeedController<InventoryParticle> getXSpeedController() {
        return this.xSpeedController;
    }

    @Generated
    public SpeedController<InventoryParticle> getYSpeedController() {
        return this.ySpeedController;
    }

    @Generated
    public RotationSpeedController<InventoryParticle> getParticleRotationSpeedController() {
        return this.particleRotationSpeedController;
    }

    @Generated
    public RotationSpeedController<InventoryParticle> getTextureRotationSpeedController() {
        return this.textureRotationSpeedController;
    }

    @NotNull
    @Generated
    public TextureAtlasSprite getTexture() {
        return this.texture;
    }

    @Override
    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public double getLastWidth() {
        return this.lastWidth;
    }

    @Generated
    public double getLastHeight() {
        return this.lastHeight;
    }

    @Override
    @Generated
    public double getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public double getHeight() {
        return this.height;
    }

    @Override
    @Generated
    public double getLastX() {
        return this.lastX;
    }

    @Override
    @Generated
    public double getLastY() {
        return this.lastY;
    }

    @Override
    @Generated
    public double getX() {
        return this.x;
    }

    @Override
    @Generated
    public double getY() {
        return this.y;
    }

    @Override
    @Generated
    public double getSpeedX() {
        return this.speedX;
    }

    @Override
    @Generated
    public double getSpeedY() {
        return this.speedY;
    }

    @Generated
    public double getLastParticleAngle() {
        return this.lastParticleAngle;
    }

    @Generated
    public double getParticleAngle() {
        return this.particleAngle;
    }

    @Generated
    public double getLastTextureAngle() {
        return this.lastTextureAngle;
    }

    @Generated
    public double getTextureAngle() {
        return this.textureAngle;
    }

    @Override
    @Generated
    public boolean isDead() {
        return this.dead;
    }

    @Override
    @Generated
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    @Generated
    public boolean isHovered() {
        return this.hovered;
    }

    @Generated
    public InventoryParticle(int lifeTimeTicks, double standardParticleAngle, double standardTextureAngle, IParticleTextureProvider textureProvider, @Nullable ColorController<InventoryParticle> colorController, DynamicSizeController<InventoryParticle> dynamicSizeController, SpeedController<InventoryParticle> xSpeedController, SpeedController<InventoryParticle> ySpeedController, RotationSpeedController<InventoryParticle> particleRotationSpeedController, RotationSpeedController<InventoryParticle> textureRotationSpeedController, @NotNull TextureAtlasSprite texture, int color, double lastWidth, double lastHeight, double width, double height, double lastX, double lastY, double x, double y, double speedX, double speedY, double lastParticleAngle, double particleAngle, double lastTextureAngle, double textureAngle, boolean dead, boolean selected, boolean hovered) {
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        this.lifeTimeTicks = lifeTimeTicks;
        this.standardParticleAngle = standardParticleAngle;
        this.standardTextureAngle = standardTextureAngle;
        this.textureProvider = textureProvider;
        this.colorController = colorController;
        this.dynamicSizeController = dynamicSizeController;
        this.xSpeedController = xSpeedController;
        this.ySpeedController = ySpeedController;
        this.particleRotationSpeedController = particleRotationSpeedController;
        this.textureRotationSpeedController = textureRotationSpeedController;
        this.texture = texture;
        this.color = color;
        this.lastWidth = lastWidth;
        this.lastHeight = lastHeight;
        this.width = width;
        this.height = height;
        this.lastX = lastX;
        this.lastY = lastY;
        this.x = x;
        this.y = y;
        this.speedX = speedX;
        this.speedY = speedY;
        this.lastParticleAngle = lastParticleAngle;
        this.particleAngle = particleAngle;
        this.lastTextureAngle = lastTextureAngle;
        this.textureAngle = textureAngle;
        this.dead = dead;
        this.selected = selected;
        this.hovered = hovered;
    }
}

