/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.element;

import lombok.Generated;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.element.base.TickElement;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class InventoryCursor
extends TickElement
implements IMovableElement {
    private ItemStack currentStack = Items.AIR.getDefaultInstance();
    @Nullable
    private Slot hoveredSlot = null;
    private double lastSpeed = 0.0;
    private double speed = 0.0;
    private double lastSpeedX = 0.0;
    private double speedX = 0.0;
    private double lastSpeedY = 0.0;
    private double speedY = 0.0;
    private double lastX = 0.0;
    private double x = 0.0;
    private double lastY = 0.0;
    private double y = 0.0;
    private double mouseX = 0.0;
    private double mouseY = 0.0;

    public void setStack(@Nullable ItemStack currentStack) {
        this.currentStack = currentStack == null || currentStack == ItemStack.EMPTY ? Items.AIR.getDefaultInstance() : currentStack;
    }

    @Override
    public void setX(double x) {
        this.lastX = this.x;
        this.x = x;
    }

    @Override
    public void setY(double y) {
        this.lastY = this.y;
        this.y = y;
    }

    public void setSpeed(double speed) {
        this.lastSpeed = this.speed;
        this.speed = speed;
    }

    @Override
    public void setSpeedX(double speedX) {
        this.lastSpeedX = this.speedX;
        this.speedX = speedX;
    }

    @Override
    public void setSpeedY(double speedY) {
        this.lastSpeedY = this.speedY;
        this.speedY = speedY;
    }

    public double getDeltaX() {
        return Math.abs(this.x - this.lastX);
    }

    public double getDeltaY() {
        return Math.abs(this.y - this.lastY);
    }

    @Override
    public double getSpeedX() {
        double rawCursorSpeedX = this.x - this.lastX;
        int directionalX = rawCursorSpeedX < 0.0 ? -1 : 1;
        return Math.sqrt(Math.abs(rawCursorSpeedX)) * (double)directionalX;
    }

    @Override
    public double getSpeedY() {
        double rawCursorSpeedY = this.y - this.lastY;
        int directionalY = rawCursorSpeedY < 0.0 ? -1 : 1;
        return Math.sqrt(Math.abs(rawCursorSpeedY)) * (double)directionalY;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticks == 1) {
            this.x = this.getMouseX();
            this.y = this.getMouseY();
            this.lastX = this.x;
            this.lastY = this.y;
        } else {
            this.setX(this.getMouseX());
            this.setY(this.getMouseY());
        }
        double rawCursorSpeedX = this.x - this.lastX;
        int directionalX = rawCursorSpeedX < 0.0 ? -1 : 1;
        this.setSpeedX(Math.sqrt(Math.abs(rawCursorSpeedX)) * (double)directionalX);
        double rawCursorSpeedY = this.y - this.lastY;
        int directionalY = rawCursorSpeedY < 0.0 ? -1 : 1;
        this.setSpeedY(Math.sqrt(Math.abs(rawCursorSpeedY)) * (double)directionalY);
        double speed = Math.sqrt(Math.pow(this.getDeltaX(), 2.0) + Math.pow(this.getDeltaY(), 2.0));
        this.setSpeed(speed);
    }

    @Generated
    public void setCurrentStack(ItemStack currentStack) {
        this.currentStack = currentStack;
    }

    @Generated
    public void setHoveredSlot(@Nullable Slot hoveredSlot) {
        this.hoveredSlot = hoveredSlot;
    }

    @Generated
    public void setLastSpeed(double lastSpeed) {
        this.lastSpeed = lastSpeed;
    }

    @Generated
    public void setLastSpeedX(double lastSpeedX) {
        this.lastSpeedX = lastSpeedX;
    }

    @Generated
    public void setLastSpeedY(double lastSpeedY) {
        this.lastSpeedY = lastSpeedY;
    }

    @Generated
    public void setLastX(double lastX) {
        this.lastX = lastX;
    }

    @Generated
    public void setLastY(double lastY) {
        this.lastY = lastY;
    }

    @Generated
    public void setMouseX(double mouseX) {
        this.mouseX = mouseX;
    }

    @Generated
    public void setMouseY(double mouseY) {
        this.mouseY = mouseY;
    }

    @Generated
    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    @Nullable
    @Generated
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Generated
    public double getLastSpeed() {
        return this.lastSpeed;
    }

    @Generated
    public double getSpeed() {
        return this.speed;
    }

    @Generated
    public double getLastSpeedX() {
        return this.lastSpeedX;
    }

    @Generated
    public double getLastSpeedY() {
        return this.lastSpeedY;
    }

    @Override
    @Generated
    public double getLastX() {
        return this.lastX;
    }

    @Override
    @Generated
    public double getX() {
        return this.x;
    }

    @Override
    @Generated
    public double getLastY() {
        return this.lastY;
    }

    @Override
    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getMouseX() {
        return this.mouseX;
    }

    @Generated
    public double getMouseY() {
        return this.mouseY;
    }
}

