/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.controller.speed;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.lopymine.ip.config.range.DoubleRange;
import net.lopymine.ip.config.speed.SpeedConfig;
import net.lopymine.ip.controller.IController;
import net.lopymine.ip.controller.modifier.speed.ISpeedControllerModifier;
import net.lopymine.ip.debug.HideInDebugRender;
import net.lopymine.ip.element.base.IMovableElement;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpeedController<C extends AbstractSpeedController<C, E>, E extends IMovableElement>
implements IController<E> {
    private List<ISpeedControllerModifier<? super C, ? super E>> modifiers = new ArrayList<ISpeedControllerModifier<? super C, ? super E>>();
    @HideInDebugRender
    protected RandomSource random;
    private double acceleration;
    private boolean accelerationBidirectional;
    private DoubleRange maxAcceleration;
    private DoubleRange max;
    private double braking;
    private DoubleRange turbulence;
    private double cursorImpulseInheritCoefficient;
    protected double lastSpeed;
    protected double speed;

    public AbstractSpeedController(SpeedConfig config, RandomSource random, double impulse) {
        this(random, config.getAcceleration(), config.isAccelerationBidirectional(), config.getMaxAcceleration(), config.getMax(), config.getBraking(), config.getTurbulence(), impulse + config.getImpulseBidirectional(random), config.getCursorImpulseInheritCoefficient());
    }

    public AbstractSpeedController(RandomSource random, double acceleration, boolean accelerationBidirectional, DoubleRange maxAcceleration, DoubleRange max, double braking, DoubleRange turbulence, double impulse, double cursorImpulseInheritCoefficient) {
        this.random = random;
        this.acceleration = acceleration;
        this.accelerationBidirectional = accelerationBidirectional && random.nextBoolean();
        this.maxAcceleration = this.accelerationBidirectional ? new DoubleRange(-maxAcceleration.getMax(), -maxAcceleration.getMin()) : maxAcceleration;
        this.max = max;
        this.braking = braking;
        this.turbulence = turbulence;
        this.speed = impulse;
        this.cursorImpulseInheritCoefficient = cursorImpulseInheritCoefficient;
    }

    @Override
    public void tick(E element) {
        boolean canApplyAcceleration;
        this.lastSpeed = this.speed;
        double acceleration = this.getAcceleration() * (double)(this.isAccelerationBidirectional() ? -1 : 1);
        for (ISpeedControllerModifier<C, E> m : this.modifiers) {
            acceleration += m.getAcceleration(element);
        }
        boolean bl = acceleration < 0.0 ? this.getSpeed() > this.getMaxAcceleration().getMin() : (canApplyAcceleration = this.speed < this.getMaxAcceleration().getMax());
        if (canApplyAcceleration && acceleration != 0.0) {
            this.speed += acceleration;
            if (this.speed < this.getMaxAcceleration().getMin()) {
                this.speed = this.getMaxAcceleration().getMin();
            }
            if (this.speed > this.getMaxAcceleration().getMax()) {
                this.speed = this.getMaxAcceleration().getMax();
            }
        }
        if (this.speed > 0.0) {
            double braking = this.getBraking();
            for (ISpeedControllerModifier<C, E> modifier : this.modifiers) {
                braking += modifier.getBraking(element);
            }
            this.speed -= braking;
            if (this.speed < 0.0) {
                this.speed = 0.0;
            }
        }
        if (this.speed < 0.0) {
            double braking = this.getBraking();
            for (ISpeedControllerModifier<C, E> modifier : this.modifiers) {
                braking += modifier.getBraking(element);
            }
            this.speed += braking;
            if (this.speed > 0.0) {
                this.speed = 0.0;
            }
        }
        double turbulence = this.getTurbulence().getRandom(this.random);
        for (ISpeedControllerModifier<C, E> modifier : this.modifiers) {
            turbulence += modifier.getTurbulence(element);
        }
        this.speed += turbulence;
        DoubleRange max = this.getMax();
        if (this.speed < max.getMin()) {
            this.speed = max.getMin();
        }
        if (this.speed > max.getMax()) {
            this.speed = max.getMax();
        }
    }

    public <M extends ISpeedControllerModifier<? super C, ? super E>> void registerModifier(M modifier) {
        this.registerModifier(modifier, false, null);
    }

    public <M extends ISpeedControllerModifier<? super C, ? super E>> void registerModifier(M modifier, boolean impulse, @Nullable E element) {
        this.modifiers.add(modifier);
        if (impulse && element != null) {
            this.speed += modifier.getImpulse(element);
        }
    }

    @Generated
    public List<ISpeedControllerModifier<? super C, ? super E>> getModifiers() {
        return this.modifiers;
    }

    @Generated
    public RandomSource getRandom() {
        return this.random;
    }

    @Generated
    public double getAcceleration() {
        return this.acceleration;
    }

    @Generated
    public boolean isAccelerationBidirectional() {
        return this.accelerationBidirectional;
    }

    @Generated
    public DoubleRange getMaxAcceleration() {
        return this.maxAcceleration;
    }

    @Generated
    public DoubleRange getMax() {
        return this.max;
    }

    @Generated
    public double getBraking() {
        return this.braking;
    }

    @Generated
    public DoubleRange getTurbulence() {
        return this.turbulence;
    }

    @Generated
    public double getCursorImpulseInheritCoefficient() {
        return this.cursorImpulseInheritCoefficient;
    }

    @Generated
    public double getLastSpeed() {
        return this.lastSpeed;
    }

    @Generated
    public double getSpeed() {
        return this.speed;
    }

    @Generated
    public void setModifiers(List<ISpeedControllerModifier<? super C, ? super E>> modifiers) {
        this.modifiers = modifiers;
    }

    @Generated
    public void setRandom(RandomSource random) {
        this.random = random;
    }

    @Generated
    public void setAcceleration(double acceleration) {
        this.acceleration = acceleration;
    }

    @Generated
    public void setAccelerationBidirectional(boolean accelerationBidirectional) {
        this.accelerationBidirectional = accelerationBidirectional;
    }

    @Generated
    public void setMaxAcceleration(DoubleRange maxAcceleration) {
        this.maxAcceleration = maxAcceleration;
    }

    @Generated
    public void setMax(DoubleRange max) {
        this.max = max;
    }

    @Generated
    public void setBraking(double braking) {
        this.braking = braking;
    }

    @Generated
    public void setTurbulence(DoubleRange turbulence) {
        this.turbulence = turbulence;
    }

    @Generated
    public void setCursorImpulseInheritCoefficient(double cursorImpulseInheritCoefficient) {
        this.cursorImpulseInheritCoefficient = cursorImpulseInheritCoefficient;
    }

    @Generated
    public void setLastSpeed(double lastSpeed) {
        this.lastSpeed = lastSpeed;
    }

    @Generated
    public void setSpeed(double speed) {
        this.speed = speed;
    }
}

