/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.controller.size;

import java.util.List;
import lombok.Generated;
import net.lopymine.ip.config.i2o.Integer2DynamicParticleSize;
import net.lopymine.ip.config.particle.DynamicParticleSize;
import net.lopymine.ip.config.particle.DynamicParticleSizeInterpolation;
import net.lopymine.ip.config.particle.DynamicParticleSizes;
import net.lopymine.ip.controller.IController;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.element.base.IResizableElement;
import net.lopymine.ip.element.base.ITickElement;
import org.jetbrains.annotations.Nullable;

public class DynamicSizeController<E extends IResizableElement & IMovableElement>
implements IController<E> {
    private DynamicParticleSizes dynamicParticleSizes;
    private Integer2DynamicParticleSize lastSize;
    private int nextSizeIndex = 0;
    @Nullable
    private Integer2DynamicParticleSize nextSize = null;

    public DynamicSizeController(DynamicParticleSizes dynamicParticleSizes, E element) {
        this.dynamicParticleSizes = dynamicParticleSizes;
        List<Integer2DynamicParticleSize> sizes = dynamicParticleSizes.getSizes();
        if (!sizes.isEmpty()) {
            Integer2DynamicParticleSize size = sizes.get(0);
            if (size.getIndex() <= 0) {
                this.resizeElement(element, size);
                element.setLastWidth(element.getWidth());
                element.setLastHeight(element.getHeight());
            } else {
                this.nextSize = size;
                this.nextSizeIndex = 0;
            }
        }
    }

    @Override
    public void tick(E element) {
        int ticks = ((ITickElement)element).getTicks();
        if (this.nextSize == null) {
            return;
        }
        if (ticks < this.nextSize.getIndex()) {
            DynamicParticleSize nextParticleSize = (DynamicParticleSize)this.nextSize.getObject();
            Integer2DynamicParticleSize lastSize = this.getLastSize(element);
            double progress = ((double)ticks - (double)lastSize.getIndex()) / ((double)this.nextSize.getIndex() - (double)lastSize.getIndex());
            DynamicParticleSizeInterpolation interpolation = nextParticleSize.getInterpolation() != DynamicParticleSizeInterpolation.NO_INTERPOLATION ? nextParticleSize.getInterpolation() : this.dynamicParticleSizes.getInterpolation();
            double lastWidth = ((DynamicParticleSize)lastSize.getObject()).getWidth();
            double nextWidth = nextParticleSize.getWidth();
            double width = interpolation.getInterpolated(lastWidth, nextWidth, progress);
            double lastHeight = ((DynamicParticleSize)lastSize.getObject()).getHeight();
            double nextHeight = nextParticleSize.getHeight();
            double height = interpolation.getInterpolated(lastHeight, nextHeight, progress);
            this.offset(element, width, height);
            element.setWidth(width);
            element.setHeight(height);
            return;
        }
        this.resizeElement(element, this.nextSize);
    }

    private Integer2DynamicParticleSize getLastSize(E element) {
        if (this.lastSize == null) {
            this.lastSize = new Integer2DynamicParticleSize(0, new DynamicParticleSize(element.getWidth(), element.getHeight()));
            return this.lastSize;
        }
        return this.lastSize;
    }

    private void resizeElement(E element, Integer2DynamicParticleSize size) {
        DynamicParticleSize particleSize = (DynamicParticleSize)size.getObject();
        this.offset(element, particleSize.getWidth(), particleSize.getHeight());
        element.setWidth(particleSize.getWidth());
        element.setHeight(particleSize.getHeight());
        this.lastSize = size;
        if (this.nextSizeIndex + 1 < this.dynamicParticleSizes.getSizes().size()) {
            ++this.nextSizeIndex;
            this.nextSize = this.dynamicParticleSizes.getSizes().get(this.nextSizeIndex);
        } else {
            this.nextSize = null;
        }
    }

    private void offset(E element, double nextWidth, double nextHeight) {
        this.offset(element, element.getWidth(), element.getHeight(), nextWidth, nextHeight);
    }

    private void offset(E element, double lastWidth, double lastHeight, double nextWidth, double nextHeight) {
        double offsetX = (nextWidth - lastWidth) / 2.0;
        double offsetY = (nextHeight - lastHeight) / 2.0;
        ((IMovableElement)element).setX(((IMovableElement)element).getX() - offsetX);
        ((IMovableElement)element).setY(((IMovableElement)element).getY() - offsetY);
    }

    @Generated
    public DynamicParticleSizes getDynamicParticleSizes() {
        return this.dynamicParticleSizes;
    }

    @Generated
    public Integer2DynamicParticleSize getLastSize() {
        return this.lastSize;
    }

    @Generated
    public int getNextSizeIndex() {
        return this.nextSizeIndex;
    }

    @Nullable
    @Generated
    public Integer2DynamicParticleSize getNextSize() {
        return this.nextSize;
    }

    @Generated
    public void setDynamicParticleSizes(DynamicParticleSizes dynamicParticleSizes) {
        this.dynamicParticleSizes = dynamicParticleSizes;
    }

    @Generated
    public void setLastSize(Integer2DynamicParticleSize lastSize) {
        this.lastSize = lastSize;
    }

    @Generated
    public void setNextSizeIndex(int nextSizeIndex) {
        this.nextSizeIndex = nextSizeIndex;
    }

    @Generated
    public void setNextSize(@Nullable Integer2DynamicParticleSize nextSize) {
        this.nextSize = nextSize;
    }
}

