/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.controller.modifier.speed;

import lombok.Generated;
import net.lopymine.ip.config.speed.SpeedConfig;
import net.lopymine.ip.controller.modifier.speed.ISpeedControllerModifier;
import net.lopymine.ip.controller.speed.SpeedController;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.element.base.IRotatableElement;
import net.minecraft.util.RandomSource;

public class SpeedInAngleDirectionControllerModifier<E extends IMovableElement & IRotatableElement>
implements ISpeedControllerModifier<SpeedController<E>, E> {
    private SpeedConfig config;
    private RandomSource random;
    private boolean xAxis;

    public SpeedInAngleDirectionControllerModifier(SpeedConfig config, RandomSource random, boolean xAxis) {
        this.config = config;
        this.random = random;
        this.xAxis = xAxis;
    }

    @Override
    public double getImpulse(E element) {
        return this.calc(this.config.getImpulseBidirectional(this.random), element);
    }

    @Override
    public double getAcceleration(E element) {
        return this.calc(this.config.getAccelerationBidirectional(this.random), element);
    }

    @Override
    public double getBraking(E element) {
        return Math.abs(this.calc(this.config.getBraking(), element));
    }

    @Override
    public double getTurbulence(E element) {
        return this.calc(this.config.getTurbulence().getRandom(this.random), element);
    }

    public double calc(double multiplier, E element) {
        if (multiplier == 0.0) {
            return 0.0;
        }
        double value = Math.toRadians(((IRotatableElement)element).getAngle());
        return (this.xAxis ? Math.sin(value) : -Math.cos(value)) * multiplier;
    }

    @Generated
    public SpeedConfig getConfig() {
        return this.config;
    }

    @Generated
    public RandomSource getRandom() {
        return this.random;
    }

    @Generated
    public boolean isXAxis() {
        return this.xAxis;
    }

    @Generated
    public void setConfig(SpeedConfig config) {
        this.config = config;
    }

    @Generated
    public void setRandom(RandomSource random) {
        this.random = random;
    }

    @Generated
    public void setXAxis(boolean xAxis) {
        this.xAxis = xAxis;
    }
}

