/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.config.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.lopymine.ip.InventoryParticles;
import net.lopymine.ip.color.IParticleColorType;
import net.lopymine.ip.color.StandardParticleColorType;
import net.lopymine.ip.color.advanced.AdvancedParticleColorType;
import net.lopymine.ip.color.advanced.mode.AdvancedParticleColorTypeRandomStaticMode;
import net.lopymine.ip.config.misc.CachedItem;
import net.lopymine.ip.config.range.IntegerRange;
import net.lopymine.ip.element.InventoryParticle;
import net.lopymine.ip.predicate.IParticleSpawnPredicate;
import net.lopymine.ip.predicate.nbt.NbtNode;
import net.lopymine.ip.predicate.nbt.NbtNodeMatch;
import net.lopymine.ip.predicate.nbt.NbtParticleSpawnPredicate;
import net.lopymine.ip.spawner.ParticleSpawner;
import net.lopymine.ip.spawner.context.ParticleSpawnContext;
import net.lopymine.mossylib.utils.CodecUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class ParticleHolder {
    public static final ResourceLocation STANDARD_SPAWN_AREA = InventoryParticles.id("spawn_areas/standard.png");
    public static final Codec<IParticleColorType> STANDARD_AND_LIST_COLOR_TYPE_CODEC = Codec.either(IParticleColorType.CODEC, (Codec)IParticleColorType.CODEC.listOf()).xmap(either -> {
        Optional right = either.right();
        if (right.isPresent()) {
            return new AdvancedParticleColorType(new AdvancedParticleColorTypeRandomStaticMode(), (List<IParticleColorType>)((List)right.get()), 0);
        }
        Optional left = either.left();
        return left.orElse(null);
    }, type -> {
        if (type instanceof AdvancedParticleColorType) {
            AdvancedParticleColorType advancedType = (AdvancedParticleColorType)type;
            return Either.right(advancedType.getValues());
        }
        return Either.left((Object)type);
    });
    public static final Codec<IParticleColorType> STANDARD_AND_ADVANCED_COLOR_TYPE_CODEC = Codec.either(AdvancedParticleColorType.CODEC, STANDARD_AND_LIST_COLOR_TYPE_CODEC).xmap(either -> {
        Optional right = either.right();
        if (right.isPresent()) {
            return (IParticleColorType)right.get();
        }
        Optional left = either.left();
        return left.orElse(null);
    }, type -> {
        if (type instanceof AdvancedParticleColorType) {
            AdvancedParticleColorType advancedType = (AdvancedParticleColorType)type;
            return Either.left((Object)advancedType);
        }
        return Either.right((Object)type);
    });
    public static final Codec<ResourceLocation> SPAWN_AREA_CODEC = Codec.STRING.comapFlatMap(s -> {
        if (s.contains(":")) {
            return ResourceLocation.read((String)s);
        }
        Object path = s.endsWith(".png") ? s : s + ".png";
        return DataResult.success((Object)InventoryParticles.id("spawn_areas/" + (String)path));
    }, ResourceLocation::toString);
    public static final Codec<ResourceLocation> TAG_CODEC = Codec.STRING.comapFlatMap(s -> {
        if (s.startsWith("#")) {
            return ResourceLocation.read((String)s.substring(1));
        }
        return DataResult.error(() -> "Failed to resolve and item, and tag from string \"%s\"".formatted(s));
    }, ResourceLocation::toString);
    public static final Codec<ParticleHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"name", () -> "UnknownParticle@" + RandomSource.create().nextIntBetweenInclusive(0, 100000), (Codec)Codec.STRING, ParticleHolder::getName), (App)CodecUtils.option((String)"item", (Object)Either.left((Object)new CachedItem()), (Codec)Codec.either(CachedItem.CODEC, TAG_CODEC), ParticleHolder::getItemOrTag), (App)CodecUtils.option((String)"nbt_conditions_match", (Object)((Object)NbtNodeMatch.ANY), NbtNodeMatch.CODEC, ParticleHolder::getMatch), (App)CodecUtils.option((String)"nbt_conditions", new HashSet(), NbtNode.CODEC, ParticleHolder::getNbtCondition), (App)CodecUtils.option((String)"spawn_area", (Object)STANDARD_SPAWN_AREA, SPAWN_AREA_CODEC, ParticleHolder::getSpawnArea), (App)CodecUtils.option((String)"spawn_count", (Object)new IntegerRange(), IntegerRange.CODEC, ParticleHolder::getSpawnCount), (App)CodecUtils.option((String)"spawn_frequency", (Object)new IntegerRange(), IntegerRange.CODEC, ParticleHolder::getSpawnFrequency), (App)CodecUtils.option((String)"color", (Object)new StandardParticleColorType(), STANDARD_AND_ADVANCED_COLOR_TYPE_CODEC, ParticleHolder::getColor), (App)CodecUtils.option((String)"speed_coefficient", (Object)0.0, (Codec)Codec.DOUBLE, ParticleHolder::getSpeedCoefficient)).apply((Applicative)instance, ParticleHolder::new));
    private String name;
    private Either<CachedItem, ResourceLocation> itemOrTag;
    private NbtNodeMatch match;
    private HashSet<NbtNode> nbtCondition;
    private ResourceLocation spawnArea;
    private IntegerRange spawnCount;
    private IntegerRange spawnFrequency;
    private IParticleColorType color;
    private double speedCoefficient;

    public ParticleSpawner create(Function<ParticleSpawnContext, InventoryParticle> function) {
        return new ParticleSpawner(this.spawnArea, this.spawnCount, this.spawnFrequency, this.speedCoefficient, this.color, this.getSpawnCondition(), function);
    }

    public IParticleSpawnPredicate getSpawnCondition() {
        return new NbtParticleSpawnPredicate(this.name, this.nbtCondition, this.match);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Either<CachedItem, ResourceLocation> getItemOrTag() {
        return this.itemOrTag;
    }

    @Generated
    public NbtNodeMatch getMatch() {
        return this.match;
    }

    @Generated
    public HashSet<NbtNode> getNbtCondition() {
        return this.nbtCondition;
    }

    @Generated
    public ResourceLocation getSpawnArea() {
        return this.spawnArea;
    }

    @Generated
    public IntegerRange getSpawnCount() {
        return this.spawnCount;
    }

    @Generated
    public IntegerRange getSpawnFrequency() {
        return this.spawnFrequency;
    }

    @Generated
    public IParticleColorType getColor() {
        return this.color;
    }

    @Generated
    public double getSpeedCoefficient() {
        return this.speedCoefficient;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setItemOrTag(Either<CachedItem, ResourceLocation> itemOrTag) {
        this.itemOrTag = itemOrTag;
    }

    @Generated
    public void setMatch(NbtNodeMatch match) {
        this.match = match;
    }

    @Generated
    public void setNbtCondition(HashSet<NbtNode> nbtCondition) {
        this.nbtCondition = nbtCondition;
    }

    @Generated
    public void setSpawnArea(ResourceLocation spawnArea) {
        this.spawnArea = spawnArea;
    }

    @Generated
    public void setSpawnCount(IntegerRange spawnCount) {
        this.spawnCount = spawnCount;
    }

    @Generated
    public void setSpawnFrequency(IntegerRange spawnFrequency) {
        this.spawnFrequency = spawnFrequency;
    }

    @Generated
    public void setColor(IParticleColorType color) {
        this.color = color;
    }

    @Generated
    public void setSpeedCoefficient(double speedCoefficient) {
        this.speedCoefficient = speedCoefficient;
    }

    @Generated
    public ParticleHolder(String name, Either<CachedItem, ResourceLocation> itemOrTag, NbtNodeMatch match, HashSet<NbtNode> nbtCondition, ResourceLocation spawnArea, IntegerRange spawnCount, IntegerRange spawnFrequency, IParticleColorType color, double speedCoefficient) {
        this.name = name;
        this.itemOrTag = itemOrTag;
        this.match = match;
        this.nbtCondition = nbtCondition;
        this.spawnArea = spawnArea;
        this.spawnCount = spawnCount;
        this.spawnFrequency = spawnFrequency;
        this.color = color;
        this.speedCoefficient = speedCoefficient;
    }
}

