/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.config.misc;

import com.mojang.serialization.Codec;
import lombok.Generated;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.mossylib.loader.MossyLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedItem {
    public static final Codec<CachedItem> CODEC = ResourceLocation.CODEC.xmap(CachedItem::new, CachedItem::getId);
    private ResourceLocation id;
    @Nullable
    private Item item;

    public CachedItem(ResourceLocation id) {
        this.id = id;
    }

    public CachedItem() {
        this.id = BuiltInRegistries.ITEM.getKey((Object)Items.AIR);
    }

    @NotNull
    public Item getItem() {
        if (this.item == null) {
            this.item = (Item)BuiltInRegistries.ITEM.get(this.id);
            if (this.item == Items.AIR && !this.id.toString().equals("minecraft:air") && (InventoryParticlesConfig.getInstance().getMainConfig().isDebugModeEnabled() || MossyLoader.isDevelopmentEnvironment())) {
                InventoryParticlesClient.LOGGER.error("Failed to find item with id \"{}\"", new Object[]{this.id});
            }
            return this.item;
        }
        return this.item;
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public void setId(ResourceLocation id) {
        this.id = id;
    }

    @Generated
    public void setItem(@Nullable Item item) {
        this.item = item;
    }

    @Generated
    public CachedItem(ResourceLocation id, @Nullable Item item) {
        this.id = id;
        this.item = item;
    }
}

