/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color.advanced.mode;

import lombok.Generated;
import net.lopymine.ip.color.advanced.mode.IAdvancedParticleColorTypeMode;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.utils.ArgbUtils2;
import net.minecraft.util.RandomSource;

public class AdvancedParticleColorTypeGradientMode
extends TickElement
implements IAdvancedParticleColorTypeMode {
    protected int time;

    public AdvancedParticleColorTypeGradientMode(int time) {
        this.time = time;
    }

    @Override
    public IAdvancedParticleColorTypeMode copy() {
        return new AdvancedParticleColorTypeGradientMode(this.time);
    }

    @Override
    public int tickResolve(Integer[] compiledColors, RandomSource random) {
        if (compiledColors.length == 1) {
            return compiledColors[0];
        }
        if (this.ticks >= this.time - 1) {
            return compiledColors[compiledColors.length - 1];
        }
        this.tick();
        float progress = (float)(this.ticks % this.time) / (float)this.time;
        int totalSegments = compiledColors.length - 1;
        float segmentProgress = progress * (float)totalSegments;
        int segmentIndex = (int)segmentProgress;
        if (segmentIndex >= totalSegments) {
            segmentIndex = totalSegments - 1;
            segmentProgress = totalSegments;
        }
        float currentSegmentProgress = segmentProgress - (float)segmentIndex;
        int first = compiledColors[segmentIndex];
        int second = compiledColors[segmentIndex + 1];
        return ArgbUtils2.lerp(currentSegmentProgress, first, second);
    }

    @Override
    public String asString() {
        return "gradient";
    }

    @Generated
    public int getTime() {
        return this.time;
    }

    @Generated
    public void setTime(int time) {
        this.time = time;
    }
}

