/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color.advanced.mode;

import lombok.Generated;
import net.lopymine.ip.color.advanced.mode.IAdvancedParticleColorTypeMode;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.utils.ArgbUtils2;
import net.minecraft.util.RandomSource;

public class AdvancedParticleColorTypeGradientBounceMode
extends TickElement
implements IAdvancedParticleColorTypeMode {
    protected final int time;

    public AdvancedParticleColorTypeGradientBounceMode(int time) {
        this.time = time;
    }

    @Override
    public IAdvancedParticleColorTypeMode copy() {
        return new AdvancedParticleColorTypeGradientBounceMode(this.time);
    }

    @Override
    public int tickResolve(Integer[] compiledColors, RandomSource random) {
        if (compiledColors.length == 1) {
            return compiledColors[0];
        }
        this.tick();
        int totalSegments = compiledColors.length - 1;
        int cycle = this.time * 2;
        int phase = this.ticks % cycle;
        float progress = phase < this.time ? (float)phase / (float)this.time : 1.0f - (float)(phase - this.time) / (float)this.time;
        float segmentProgress = progress * (float)totalSegments;
        int segmentIndex = (int)segmentProgress;
        if (segmentIndex >= totalSegments) {
            segmentIndex = totalSegments - 1;
            segmentProgress = totalSegments;
        }
        float currentSegmentProgress = segmentProgress - (float)segmentIndex;
        int first = compiledColors[segmentIndex];
        int second = compiledColors[segmentIndex + 1];
        return ArgbUtils2.lerp(currentSegmentProgress, first, second);
    }

    @Override
    public String asString() {
        return "gradient";
    }

    @Generated
    public int getTime() {
        return this.time;
    }
}

