/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color;

import lombok.Generated;
import net.lopymine.ip.color.IListParticleColorType;
import net.lopymine.ip.color.IParticleColorType;
import net.lopymine.ip.utils.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NbtListParticleColorType
implements IParticleColorType,
IListParticleColorType {
    public static final Integer[] NO_COLOR = new Integer[]{-1};
    private Integer[] colors;
    @Nullable
    private Integer currentColor;

    private static Integer[] getColorFromStack(ItemStack stack) {
        return NbtUtils.getColorsFromStack(stack).orElse(NO_COLOR);
    }

    @Override
    public Integer[] getList() {
        return this.colors;
    }

    @Override
    public int tick(RandomSource random) {
        if (this.currentColor != null) {
            return this.currentColor;
        }
        if (this.colors.length == 0) {
            return -1;
        }
        this.currentColor = this.colors[random.nextIntBetweenInclusive(0, this.colors.length - 1)];
        return this.currentColor;
    }

    @Override
    public IParticleColorType copy() {
        return new NbtListParticleColorType();
    }

    @Override
    public void compile(ItemStack stack, RandomSource random) {
        this.colors = NbtListParticleColorType.getColorFromStack(stack);
    }

    @Override
    public String asString() {
        return "nbt_list";
    }

    public String toString() {
        return this.asString();
    }

    @Generated
    public Integer[] getColors() {
        return this.colors;
    }

    @Nullable
    @Generated
    public Integer getCurrentColor() {
        return this.currentColor;
    }

    @Generated
    public void setColors(Integer[] colors) {
        this.colors = colors;
    }

    @Generated
    public void setCurrentColor(@Nullable Integer currentColor) {
        this.currentColor = currentColor;
    }
}

