/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color;

import lombok.Generated;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.color.IParticleColorType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class CustomParticleColorType
implements IParticleColorType {
    private final String original;
    private int color = -1;

    public CustomParticleColorType(String original) {
        this.original = original;
    }

    @Override
    public IParticleColorType copy() {
        return new CustomParticleColorType(this.original);
    }

    @Override
    public int tick(RandomSource random) {
        return this.color;
    }

    @Override
    public void compile(ItemStack stack, RandomSource random) {
        try {
            String color = this.original.substring(1);
            if (color.length() == 6) {
                this.color = 0xFF000000 | Integer.parseInt(color, 16);
            } else if (color.length() == 8) {
                this.color = (int)Long.parseLong(color, 16);
            }
        }
        catch (Exception e) {
            InventoryParticlesClient.LOGGER.error("Failed to parse custom color from \"{}\"! Reason:", new Object[]{this.original, e});
        }
    }

    @Override
    public String asString() {
        return "custom";
    }

    public String toString() {
        return this.getString(this.color);
    }

    @Generated
    public String getOriginal() {
        return this.original;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public void setColor(int color) {
        this.color = color;
    }
}

