/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.client.command.tags;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.lopymine.mossylib.loader.MossyLoader;
import net.lopymine.mossylib.utils.CommandUtils;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class TagsCommand {
    public static final Path FOLDER = MossyLoader.getConfigDir().resolve("inventory_particles".replace("_", "-"));

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandUtils.literal((String)"tags").then(CommandUtils.literal((String)"items-for-tag").then(CommandUtils.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggest(TagsCommand.getAvailableTags(), (SuggestionsBuilder)builder)).executes(TagsCommand::items)))).then(CommandUtils.literal((String)"tags-in-item").then(CommandUtils.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggest(TagsCommand.getAvailableItems(), (SuggestionsBuilder)builder)).executes(TagsCommand::tags)))).then(CommandUtils.literal((String)"list").executes(TagsCommand::list));
    }

    private static int tags(CommandContext<CommandSourceStack> context) {
        ResourceLocation item = (ResourceLocation)context.getArgument("item", ResourceLocation.class);
        if (!TagsCommand.getAvailableItems().contains(item.toString())) {
            return 0;
        }
        Item get = (Item)BuiltInRegistries.ITEM.get(item);
        List<String> list = get.builtInRegistryHolder().tags().map(TagKey::location).map(ResourceLocation::toString).toList();
        TagsCommand.writeAndOpen("tags-in-item.txt", list);
        return 1;
    }

    private static int items(CommandContext<CommandSourceStack> context) {
        ResourceLocation tag = (ResourceLocation)context.getArgument("tag", ResourceLocation.class);
        if (!TagsCommand.getAvailableTags().contains(tag.toString())) {
            return 0;
        }
        Optional optional = BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag));
        if (optional.isEmpty()) {
            return 0;
        }
        List<String> list = ((HolderSet.Named)optional.get()).stream().map(Holder::value).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(ResourceLocation::toString).toList();
        TagsCommand.writeAndOpen("items-with-tag.txt", list);
        return 1;
    }

    private static int list(CommandContext<CommandSourceStack> context) {
        TagsCommand.writeAndOpen("available-tags.txt", TagsCommand.getAvailableTags());
        return 1;
    }

    private static void writeAndOpen(String file, List<String> list) {
        String text = String.join((CharSequence)"\n", list);
        try {
            Path path;
            if (!Files.exists(FOLDER, new LinkOption[0])) {
                Files.createDirectory(FOLDER, new FileAttribute[0]);
            }
            if (!Files.exists(path = FOLDER.resolve(file), new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)text, new OpenOption[0]);
            Util.getPlatform().openUri(path.toUri());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static List<String> getAvailableTags() {
        return BuiltInRegistries.ITEM.getTags().map(Pair::getFirst).map(TagKey::location).map(ResourceLocation::toString).toList();
    }

    @NotNull
    private static List<String> getAvailableItems() {
        return BuiltInRegistries.ITEM.entrySet().stream().map(Map.Entry::getKey).map(ResourceKey::location).map(ResourceLocation::toString).toList();
    }
}

