/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.hud_batching.consumer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.raphimc.immediatelyfast.feature.batching.BatchingBuffers;
import net.raphimc.immediatelyfast.feature.batching.BatchingRenderLayers;
import net.raphimc.immediatelyfast.feature.batching.BlendFuncDepthFuncState;
import net.raphimc.immediatelyfast.injection.processors.InjectAboveEverything;
import net.raphimc.immediatelyfast.injection.processors.InjectOnAllReturns;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1500)
public abstract class MixinDrawContext {
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    @Mutable
    private MultiBufferSource.BufferSource bufferSource;
    @Unique
    private MultiBufferSource.BufferSource immediatelyFast$originalVertexConsumers;

    @Shadow
    protected abstract void fillGradient(VertexConsumer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)V"}, at={@At(value="RETURN")})
    private void storeOriginalVertexConsumers(CallbackInfo ci) {
        this.immediatelyFast$originalVertexConsumers = this.bufferSource;
    }

    @Inject(method={"fill(Lnet/minecraft/client/renderer/RenderType;IIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fillIntoBuffer(RenderType layer, int x1, int y1, int x2, int y2, int z, int color, CallbackInfo ci) {
        if (BatchingBuffers.FILL_CONSUMER != null) {
            ci.cancel();
            if (x1 < x2) {
                x1 ^= x2;
                x2 = x1 ^ x2;
                x1 ^= x2;
            }
            if (y1 < y2) {
                y1 ^= y2;
                y2 = y1 ^ y2;
                y1 ^= y2;
            }
            Matrix4f matrix = this.pose.last().pose();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            color = FastColor.ARGB32.multiply((int)color, (int)argb);
            VertexConsumer vertexConsumer = BatchingBuffers.FILL_CONSUMER.getBuffer(layer);
            vertexConsumer.addVertex(matrix, (float)x1, (float)y2, (float)z).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y1, (float)z).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x1, (float)y1, (float)z).setColor(color);
        }
    }

    @Inject(method={"fillGradient(Lnet/minecraft/client/renderer/RenderType;IIIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fillIntoBuffer(RenderType layer, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z, CallbackInfo ci) {
        if (BatchingBuffers.FILL_CONSUMER != null) {
            ci.cancel();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            colorStart = FastColor.ARGB32.multiply((int)colorStart, (int)argb);
            colorEnd = FastColor.ARGB32.multiply((int)colorEnd, (int)argb);
            this.fillGradient(BatchingBuffers.FILL_CONSUMER.getBuffer(layer), startX, startY, endX, endY, z, colorStart, colorEnd);
        }
    }

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, CallbackInfo ci) {
        if (BatchingBuffers.TEXTURE_CONSUMER != null) {
            ci.cancel();
            Matrix4f matrix = this.pose.last().pose();
            float[] shaderColor = RenderSystem.getShaderColor();
            int r = (int)(shaderColor[0] * 255.0f);
            int g = (int)(shaderColor[1] * 255.0f);
            int b = (int)(shaderColor[2] * 255.0f);
            int a = (int)(shaderColor[3] * 255.0f);
            VertexConsumer vertexConsumer = BatchingBuffers.TEXTURE_CONSUMER.getBuffer(BatchingRenderLayers.COLORED_TEXTURE.apply(this.minecraft.getTextureManager().getTexture(texture).getId(), BlendFuncDepthFuncState.current()));
            vertexConsumer.addVertex(matrix, (float)x1, (float)y2, (float)z).setUv(u1, v2).setColor(r, g, b, a);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2).setColor(r, g, b, a);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y1, (float)z).setUv(u2, v1).setColor(r, g, b, a);
            vertexConsumer.addVertex(matrix, (float)x1, (float)y1, (float)z).setUv(u1, v1).setColor(r, g, b, a);
        }
    }

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (BatchingBuffers.TEXTURE_CONSUMER != null) {
            ci.cancel();
            Matrix4f matrix = this.pose.last().pose();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            int color = FastColor.ARGB32.multiply((int)((int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f)), (int)argb);
            RenderSystem.enableBlend();
            VertexConsumer vertexConsumer = BatchingBuffers.TEXTURE_CONSUMER.getBuffer(BatchingRenderLayers.COLORED_TEXTURE.apply(this.minecraft.getTextureManager().getTexture(texture).getId(), BlendFuncDepthFuncState.current()));
            vertexConsumer.addVertex(matrix, (float)x1, (float)y2, (float)z).setUv(u1, v2).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y1, (float)z).setUv(u2, v1).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x1, (float)y1, (float)z).setUv(u1, v1).setColor(color);
            RenderSystem.disableBlend();
        }
    }

    @InjectAboveEverything
    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="HEAD")})
    private void renderItemIntoBufferStart(CallbackInfo ci) {
        if (BatchingBuffers.ITEM_MODEL_CONSUMER != null) {
            this.bufferSource = (MultiBufferSource.BufferSource)BatchingBuffers.ITEM_MODEL_CONSUMER;
        }
    }

    @InjectOnAllReturns
    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="RETURN")})
    private void renderItemIntoBufferEnd(CallbackInfo ci) {
        if (BatchingBuffers.ITEM_MODEL_CONSUMER != null) {
            this.bufferSource = this.immediatelyFast$originalVertexConsumers;
        }
    }

    @InjectAboveEverything
    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    private void renderItemOverlayIntoBufferStart(CallbackInfo ci) {
        BatchingBuffers.beginItemOverlayRendering();
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            this.bufferSource = (MultiBufferSource.BufferSource)BatchingBuffers.ITEM_OVERLAY_CONSUMER;
        }
    }

    @InjectOnAllReturns
    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void renderItemOverlayIntoBufferEnd(CallbackInfo ci) {
        BatchingBuffers.endItemOverlayRendering();
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            this.bufferSource = this.immediatelyFast$originalVertexConsumers;
        }
    }

    @Inject(method={"flush()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontDrawIfBatching(CallbackInfo ci) {
        if (this.bufferSource != this.immediatelyFast$originalVertexConsumers) {
            ci.cancel();
        }
    }

    @Inject(method={"applyScissor(Lnet/minecraft/client/gui/navigation/ScreenRectangle;)V"}, at={@At(value="HEAD")})
    private void forceDrawBatch(CallbackInfo ci) {
        if (BatchingBuffers.isHudBatching() && BatchingBuffers.hasDataToDraw()) {
            BatchingBuffers.forceDrawBuffers();
        }
    }
}

