/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.core.compat;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.CoreShaderBlacklist;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    @Final
    private Map<String, ShaderInstance> shaders;

    @Inject(method={"reloadShaders(Lnet/minecraft/server/packs/resources/ResourceProvider;)V"}, at={@At(value="RETURN")})
    private void checkForCoreShaderModifications(ResourceProvider factory, CallbackInfo ci) {
        boolean modified = false;
        for (Map.Entry<String, ShaderInstance> shaderProgramEntry : this.shaders.entrySet()) {
            if (!CoreShaderBlacklist.isBlacklisted(shaderProgramEntry.getKey())) continue;
            ResourceLocation vertexShaderIdentifier = ResourceLocation.parse((String)("shaders/core/" + shaderProgramEntry.getValue().getVertexProgram().getName() + ".vsh"));
            Resource vertexShaderResource = factory.getResource(vertexShaderIdentifier).orElse(null);
            if (vertexShaderResource != null && !vertexShaderResource.source().equals((Object)this.minecraft.getVanillaPackResources())) {
                modified = true;
                break;
            }
            ResourceLocation fragmentShaderIdentifier = ResourceLocation.parse((String)("shaders/core/" + shaderProgramEntry.getValue().getFragmentProgram().getName() + ".fsh"));
            Resource fragmentShaderResource = factory.getResource(fragmentShaderIdentifier).orElse(null);
            if (fragmentShaderResource == null || fragmentShaderResource.source().equals((Object)this.minecraft.getVanillaPackResources())) continue;
            modified = true;
            break;
        }
        if (modified && !ImmediatelyFast.config.experimental_disable_resource_pack_conflict_handling) {
            ImmediatelyFast.LOGGER.warn("Core shader modifications detected. Temporarily disabling some parts of ImmediatelyFast.");
            if (ImmediatelyFast.runtimeConfig.font_atlas_resizing) {
                ImmediatelyFast.runtimeConfig.font_atlas_resizing = false;
                this.immediatelyFast$reloadFontStorages();
            }
            ImmediatelyFast.runtimeConfig.hud_batching = false;
        } else {
            if (!ImmediatelyFast.runtimeConfig.font_atlas_resizing && ImmediatelyFast.config.font_atlas_resizing) {
                ImmediatelyFast.runtimeConfig.font_atlas_resizing = true;
                this.immediatelyFast$reloadFontStorages();
            }
            ImmediatelyFast.runtimeConfig.hud_batching = ImmediatelyFast.config.hud_batching;
        }
    }

    @Unique
    private void immediatelyFast$reloadFontStorages() {
        Minecraft.getInstance().fontManager.updateOptions(Minecraft.getInstance().options);
    }
}

