/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo.block.rotator;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.rotator.BlockCamoRotator;
import xfacthd.framedblocks.api.camo.block.rotator.RegisterBlockCamoRotatorsEvent;
import xfacthd.framedblocks.api.camo.block.rotator.SimpleBlockCamoRotator;
import xfacthd.framedblocks.common.data.FramedDataMaps;
import xfacthd.framedblocks.common.data.camo.CamoContainerFactories;

public final class BlockCamoRotators {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Reference2ObjectMap<Block, BlockCamoRotator> ROTATORS = new Reference2ObjectOpenHashMap();
    private static final BlockCamoRotator AXIS = new SimpleBlockCamoRotator((Property<?>)RotatedPillarBlock.AXIS);
    private static final BlockCamoRotator DIR = new SimpleBlockCamoRotator((Property<?>)DirectionalBlock.FACING);
    private static final BlockCamoRotator HOR_DIR = new SimpleBlockCamoRotator((Property<?>)HorizontalDirectionalBlock.FACING);
    private static final BlockCamoRotator REDSTONE_LAMP = new SimpleBlockCamoRotator((Property<?>)RedstoneLampBlock.LIT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockCamoRotator get(Block block) {
        Reference2ObjectMap<Block, BlockCamoRotator> reference2ObjectMap = ROTATORS;
        synchronized (reference2ObjectMap) {
            return (BlockCamoRotator)ROTATORS.getOrDefault((Object)block, (Object)BlockCamoRotator.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Reference2ObjectMap<Block, BlockCamoRotator> reference2ObjectMap = ROTATORS;
        synchronized (reference2ObjectMap) {
            BlockCamoRotators.reloadSync();
        }
    }

    private static void reloadSync() {
        ROTATORS.clear();
        Stopwatch stopwatch = Stopwatch.createStarted();
        BuiltInRegistries.BLOCK.forEach(block -> {
            ItemStack stack = block.asItem().getDefaultInstance();
            if (stack.isEmpty()) {
                return;
            }
            CamoContainerFactory<?> factory = CamoContainerFactories.findCamoFactory(stack);
            if (!(factory instanceof AbstractBlockCamoContainerFactory)) {
                return;
            }
            AbstractBlockCamoContainerFactory blockFactory = (AbstractBlockCamoContainerFactory)factory;
            if (!blockFactory.isValidBlockInternal(block.defaultBlockState())) {
                return;
            }
            Block block2 = block;
            Objects.requireNonNull(block2);
            Block selector0$temp = block2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RotatedPillarBlock.class, InfestedRotatedPillarBlock.class, DirectionalBlock.class, HorizontalDirectionalBlock.class, RedstoneLampBlock.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    RotatedPillarBlock ignored = (RotatedPillarBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, RotatedPillarBlock.AXIS, AXIS);
                    break;
                }
                case 1: {
                    InfestedRotatedPillarBlock ignored = (InfestedRotatedPillarBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, RotatedPillarBlock.AXIS, AXIS);
                    break;
                }
                case 2: {
                    DirectionalBlock ignored = (DirectionalBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, DirectionalBlock.FACING, DIR);
                    break;
                }
                case 3: {
                    HorizontalDirectionalBlock ignored = (HorizontalDirectionalBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, HorizontalDirectionalBlock.FACING, HOR_DIR);
                    break;
                }
                case 4: {
                    RedstoneLampBlock ignored = (RedstoneLampBlock)selector0$temp;
                    BlockCamoRotators.addIfPropPresent(block, RedstoneLampBlock.LIT, REDSTONE_LAMP);
                    break;
                }
            }
        });
        int defaultCount = ROTATORS.size();
        MutableInt customCount = new MutableInt();
        NeoForge.EVENT_BUS.post((Event)new RegisterBlockCamoRotatorsEvent((key, value) -> {
            ROTATORS.put(key, value);
            customCount.increment();
        }));
        MutableInt datapackCount = new MutableInt();
        BuiltInRegistries.BLOCK.getDataMap(FramedDataMaps.BLOCK_CAMO_ROTATORS).forEach((key, prototype) -> {
            Block block = (Block)BuiltInRegistries.BLOCK.getOrThrow(key);
            if (!prototype.isApplicableTo(block)) {
                LOGGER.error("BlockCamoRotator for property {} from datamap cannot be applied to {}, dropping!", (Object)prototype.property(), (Object)block);
                return;
            }
            ROTATORS.put((Object)block, (Object)prototype.build(block));
            datapackCount.increment();
        });
        stopwatch.stop();
        int totalCount = ROTATORS.size();
        LOGGER.debug("Collected {} camo rotators ({} default, {} custom, {} datamap) in {}", new Object[]{totalCount, defaultCount, customCount.intValue(), datapackCount.intValue(), stopwatch});
    }

    private static void addIfPropPresent(Block block, Property<?> property, BlockCamoRotator rotator) {
        if (block.defaultBlockState().hasProperty(property)) {
            ROTATORS.put((Object)block, (Object)rotator);
        }
    }

    private BlockCamoRotators() {
    }
}

