/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.vertical;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedVerticalStairsBlock
extends FramedBlock {
    public FramedVerticalStairsBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.STAIRS_TYPE, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.STATE_LOCKED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withCustom((state, modCtx) -> FramedVerticalStairsBlock.getStateFromContext(state, (LevelAccessor)modCtx.getLevel(), modCtx.getClickedPos()))).tryWithWater()).build();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (facing != dir.getOpposite() && facing != dir.getClockWise()) {
            state = FramedVerticalStairsBlock.getStateFromContext(state, level, pos);
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    private static BlockState getStateFromContext(BlockState state, LevelAccessor level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        BlockState front = level.getBlockState(pos.relative(dir));
        BlockState left = level.getBlockState(pos.relative(dir.getCounterClockWise()));
        if (FramedVerticalStairsBlock.isNoStair(front) && FramedVerticalStairsBlock.isNoStair(left)) {
            return (BlockState)state.setValue(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)StairsType.VERTICAL));
        }
        boolean topCornerFront = false;
        boolean bottomCornerFront = false;
        if (front.getBlock() instanceof StairBlock && front.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == dir.getCounterClockWise()) {
            topCornerFront = front.getValue((Property)BlockStateProperties.HALF) == Half.BOTTOM;
            bottomCornerFront = front.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        } else if (front.getBlock() instanceof FramedHalfStairsBlock && front.getValue((Property)FramedProperties.FACING_HOR) == dir.getCounterClockWise()) {
            boolean top = (Boolean)front.getValue((Property)FramedProperties.TOP);
            if (!((Boolean)front.getValue((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCornerFront = !top;
                bottomCornerFront = top;
            }
        }
        boolean topCornerLeft = false;
        boolean bottomCornerLeft = false;
        if (left.getBlock() instanceof StairBlock && left.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == dir) {
            topCornerLeft = left.getValue((Property)BlockStateProperties.HALF) == Half.BOTTOM;
            bottomCornerLeft = left.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        } else if (left.getBlock() instanceof FramedHalfStairsBlock && left.getValue((Property)FramedProperties.FACING_HOR) == dir) {
            boolean top = (Boolean)left.getValue((Property)FramedProperties.TOP);
            if (((Boolean)left.getValue((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCornerLeft = !top;
                bottomCornerLeft = top;
            }
        }
        BlockState above = level.getBlockState(pos.above());
        BlockState below = level.getBlockState(pos.below());
        StairsType type = StairsType.VERTICAL;
        if ((topCornerFront || topCornerLeft) && !(above.getBlock() instanceof FramedVerticalStairsBlock)) {
            type = !topCornerLeft ? StairsType.TOP_FWD : (!topCornerFront ? StairsType.TOP_CCW : StairsType.TOP_BOTH);
        } else if ((bottomCornerFront || bottomCornerLeft) && !(below.getBlock() instanceof FramedVerticalStairsBlock)) {
            type = !bottomCornerLeft ? StairsType.BOTTOM_FWD : (!bottomCornerFront ? StairsType.BOTTOM_CCW : StairsType.BOTTOM_BOTH);
        }
        return (BlockState)state.setValue(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)type));
    }

    private static boolean isNoStair(BlockState state) {
        return !(state.getBlock() instanceof StairBlock) && !(state.getBlock() instanceof FramedHalfStairsBlock);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

