/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedFlatInverseDoubleSlopeSlabCornerBlock
extends AbstractFramedDoubleBlock {
    public FramedFlatInverseDoubleSlopeSlabCornerBlock() {
        super(BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction face = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        if (face == dir.getOpposite() || face == dir.getClockWise()) {
            Vec3 vec = Utils.fraction(hit.getLocation());
            if (vec.y > 0.5 != top) {
                face = top ? Direction.DOWN : Direction.UP;
            }
        } else if (face == dir || face == dir.getCounterClockWise()) {
            double hor;
            Vec3 vec = Utils.fraction(hit.getLocation());
            Direction perpDir = face == dir.getClockWise() ? dir : dir.getCounterClockWise();
            double d = hor = Utils.isX(perpDir) ? vec.x() : vec.z();
            if (!Utils.isPositive(perpDir)) {
                hor = 1.0 - hor;
            }
            double y = vec.y();
            y = top ? (y -= 0.5) : 0.5 - y;
            if (y * 2.0 >= hor) {
                face = top ? Direction.DOWN : Direction.UP;
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)FramedProperties.TOP);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(top))).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(!top))).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (((Boolean)state.getValue((Property)FramedProperties.TOP)).booleanValue()) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        boolean top;
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if ((side == facing.getOpposite() || side == facing.getClockWise()) && (!(top = ((Boolean)state.getValue((Property)FramedProperties.TOP)).booleanValue()) && edge == Direction.DOWN || top && edge == Direction.UP)) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

