/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedStorageBlock
extends FramedBlock {
    public FramedStorageBlock(BlockType type) {
        super(type);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.SOLID});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedStorageBlockEntity) {
            FramedStorageBlockEntity be = (FramedStorageBlockEntity)blockEntity;
            be.open((ServerPlayer)player);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (newState.getBlock() != state.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedStorageBlockEntity) {
            FramedStorageBlockEntity be = (FramedStorageBlockEntity)blockEntity;
            be.getDrops().forEach(stack -> FramedStorageBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
            be.clearContent();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (customName != null && (blockEntity = level.getBlockEntity(pos)) instanceof FramedStorageBlockEntity) {
            FramedStorageBlockEntity be = (FramedStorageBlockEntity)blockEntity;
            be.setCustomName(customName);
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedStorageBlockEntity) {
            FramedStorageBlockEntity be = (FramedStorageBlockEntity)blockEntity;
            return be.getAnalogOutputSignal();
        }
        return 0;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedStorageBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return state;
    }
}

