/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.loader.fallback;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.conditions.ICondition;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.loader.fallback.FallbackGeometry;

public final class FallbackLoader
implements IGeometryLoader<FallbackGeometry> {
    public static final ResourceLocation ID = Utils.rl("fallback");

    public FallbackGeometry read(JsonObject json, JsonDeserializationContext ctx) throws JsonParseException {
        FallbackGeometry fallbackGeometry;
        block9: {
            JsonArray conditionArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"conditions");
            List conditions = (List)((Pair)ICondition.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)conditionArray).getOrThrow(err -> new JsonParseException("Failed to parse conditions: " + err))).getFirst();
            if (conditions.stream().allMatch(cond -> cond.test(ICondition.IContext.EMPTY))) {
                json.remove("loader");
                return new FallbackGeometry((BlockModel)ctx.deserialize((JsonElement)json, BlockModel.class));
            }
            ResourceLocation fallback = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"fallback"));
            fallback = ModelBakery.MODEL_LISTER.idToFile(fallback);
            Resource resource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(fallback);
            BufferedReader reader = resource.openAsReader();
            try {
                fallbackGeometry = new FallbackGeometry(BlockModel.fromStream((Reader)reader));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JsonParseException("Failed to parse fallback model", (Throwable)e);
                }
            }
            ((Reader)reader).close();
        }
        return fallbackGeometry;
    }
}

