/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.AECapabilities;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.util.SettingsFrom;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PartExPatternProvider
extends AEBasePart
implements PatternProviderLogicHost {
    public static List<ResourceLocation> MODELS = Arrays.asList(ResourceLocation.fromNamespaceAndPath((String)"extendedae", (String)"part/ex_pattern_provider_base"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_on"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_off"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});
    protected final PatternProviderLogic logic = this.createLogic();

    public PartExPatternProvider(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.logic.onMainNodeStateChanged();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.logic.readFromNBT(data, registries);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        this.logic.writeToNBT(data, registries);
    }

    public void addToWorld() {
        super.addToWorld();
        this.logic.updatePatterns();
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        this.logic.addDrops(drops);
    }

    public void clearContent() {
        super.clearContent();
        this.logic.clearContent();
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder builder) {
        super.exportSettings(mode, builder);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(builder);
        }
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.importSettings(input, player);
        }
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        this.logic.updateRedstoneState();
    }

    public boolean onUseWithoutItem(Player p, Vec3 pos) {
        if (!p.getCommandSenderWorld().isClientSide()) {
            this.openMenu(p, MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void openMenu(Player player, MenuHostLocator locator) {
        MenuOpener.open(ContainerExPatternProvider.TYPE, (Player)player, (MenuHostLocator)locator);
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExPatternProvider.TYPE, (Player)player, (MenuHostLocator)subMenu.getLocator());
    }

    protected PatternProviderLogic createLogic() {
        return new PatternProviderLogic(this.getMainNode(), (PatternProviderLogicHost)this, 36);
    }

    public PatternProviderLogic getLogic() {
        return this.logic;
    }

    public EnumSet<Direction> getTargets() {
        return EnumSet.of(this.getSide());
    }

    public void saveChanges() {
        this.getHost().markForSave();
    }

    public AEItemKey getTerminalIcon() {
        return AEItemKey.of((ItemLike)this.getPartItem());
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        return this.isPowered() ? MODELS_ON : MODELS_OFF;
    }

    public static void registerCapability(RegisterPartCapabilitiesEvent event) {
        event.register(AECapabilities.GENERIC_INTERNAL_INV, (part, context) -> part.logic.getReturnInv(), PartExPatternProvider.class);
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack(EAESingletons.EX_PATTERN_PROVIDER_PART);
    }
}

